/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.js.bower.internal.util;

import java.io.File;
import org.jboss.tools.common.util.PlatformUtil;
import org.jboss.tools.jst.js.bower.internal.preference.BowerPreferenceHolder;

public final class ExternalToolUtil {
    public static String getBowerExecutableLocation() {
        String bowerExecutableLocation = null;
        File bowerExecutable = new File(BowerPreferenceHolder.getBowerLocation(), "bower");
        if (bowerExecutable != null && bowerExecutable.exists()) {
            bowerExecutableLocation = bowerExecutable.getAbsolutePath();
        }
        return bowerExecutableLocation;
    }

    public static String getNodeExecutableLocation() {
        String nodeExecutableLocation = null;
        String nodeExecutableName = ExternalToolUtil.getNodeExecutableName();
        File nodeExecutable = new File(BowerPreferenceHolder.getNodeLocation(), nodeExecutableName);
        if (nodeExecutable.exists()) {
            nodeExecutableLocation = nodeExecutable.getAbsolutePath();
        } else if (!PlatformUtil.isMacOS()) {
            if (PlatformUtil.isLinux()) {
                nodeExecutableName = "node";
            } else if (PlatformUtil.isWindows()) {
                nodeExecutableName = "node64.exe";
            }
            nodeExecutable = new File(BowerPreferenceHolder.getNodeLocation(), nodeExecutableName);
            if (nodeExecutable.exists()) {
                nodeExecutableLocation = nodeExecutable.getAbsolutePath();
            }
        }
        return nodeExecutableLocation;
    }

    public static String getNodeExecutableName() {
        String name = null;
        switch (PlatformUtil.getOs()) {
            case WINDOWS: {
                name = "node.exe";
                break;
            }
            case MACOS: {
                name = "node";
                break;
            }
            case LINUX: {
                name = "nodejs";
                break;
            }
            case OTHER: {
                name = "node";
            }
        }
        return name;
    }
}

