/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.js.bower.internal.launch.shortcut;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.jboss.tools.jst.js.bower.BowerCommands;
import org.jboss.tools.jst.js.bower.internal.launch.shortcut.GenericNativeBowerLaunch;
import org.jboss.tools.jst.js.bower.util.BowerUtil;
import org.jboss.tools.jst.js.internal.Activator;

public class BowerUpdate
extends GenericNativeBowerLaunch {
    private static final String LAUNCH_NAME = "Bower Update";

    @Override
    protected String getCommandName() {
        return BowerCommands.UPDATE.getValue();
    }

    @Override
    protected String getLaunchName() {
        return LAUNCH_NAME;
    }

    @Override
    protected String getWorkingDirectory(IResource resource) throws CoreException {
        String workingDir = null;
        if (resource != null && resource.exists()) {
            if (resource.getType() == 1 && "bower.json".equals(resource.getName())) {
                workingDir = resource.getParent().getFullPath().toOSString();
            } else if (resource.getType() == 2) {
                workingDir = resource.getFullPath().toOSString();
            } else if (resource.getType() == 4) {
                IProject project = (IProject)resource;
                IFile file = project.getFile("bower.json");
                if (file.exists()) {
                    workingDir = resource.getFullPath().toOSString();
                } else {
                    try {
                        workingDir = this.getWorkingDirectory(project);
                    }
                    catch (IOException e) {
                        Activator.logError(e);
                    }
                }
            }
        }
        return workingDir;
    }

    private String getWorkingDirectory(IProject project) throws CoreException, UnsupportedEncodingException {
        String workingDir = null;
        IFile bowerrc = BowerUtil.getBowerrc(project);
        if (bowerrc != null) {
            IContainer parent = bowerrc.getParent();
            if (parent.exists() && parent.findMember("bower.json") != null) {
                workingDir = parent.getFullPath().toOSString();
            } else {
                String directoryName = BowerUtil.getDirectoryName(bowerrc);
                directoryName = directoryName != null ? directoryName : "bower_components";
                workingDir = BowerUtil.getBowerWorkingDir(project, directoryName);
            }
        } else {
            workingDir = BowerUtil.getBowerWorkingDir(project, "bower_components");
        }
        return workingDir;
    }
}

