/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.ui.utils;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import tern.eclipse.ide.internal.ui.TernUIMessages;
import tern.eclipse.ide.ui.dialogs.FolderSelectionDialog;
import tern.utils.StringUtils;

public class DialogUtils {
    public static IResource openFolderDialog(String initialFolder, IProject project, boolean showAllProjects, Shell shell) {
        SelectionDialog dialog = DialogUtils.createFolderDialog(initialFolder, project, showAllProjects, shell);
        if (dialog.open() != 0) {
            return null;
        }
        Object[] results = dialog.getResult();
        if (results != null && results.length > 0) {
            return (IResource)results[0];
        }
        return null;
    }

    private static SelectionDialog createFolderDialog(String initialFolder, final IProject project, final boolean showAllProjects, Shell shell) {
        IFolder folder;
        WorkbenchLabelProvider lp = new WorkbenchLabelProvider();
        WorkbenchContentProvider cp = new WorkbenchContentProvider();
        FolderSelectionDialog dialog = new FolderSelectionDialog(shell, (ILabelProvider)lp, (ITreeContentProvider)cp);
        dialog.setTitle(TernUIMessages.TernModuleOptionsPanel_selectPathDialogTitle);
        IFolder iFolder = folder = StringUtils.isEmpty((String)initialFolder) ? null : project.getFolder(initialFolder);
        if (folder != null && folder.exists()) {
            dialog.setInitialSelection(folder);
        }
        dialog.setInput(ResourcesPlugin.getWorkspace().getRoot());
        ViewerFilter filter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IProject) {
                    if (showAllProjects) {
                        return true;
                    }
                    IProject p = (IProject)element;
                    return p.equals((Object)project);
                }
                if (element instanceof IContainer) {
                    IContainer container = (IContainer)element;
                    return container.getType() == 2;
                }
                return false;
            }
        };
        dialog.addFilter(filter);
        return dialog;
    }
}

