/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.ui.controls;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import tern.eclipse.ide.core.IIDETernProject;
import tern.eclipse.ide.core.TernCorePlugin;
import tern.eclipse.ide.internal.ui.TernUIMessages;
import tern.eclipse.ide.ui.TernUIPlugin;
import tern.eclipse.ide.ui.controls.AbstractTreeBlock;
import tern.eclipse.ide.ui.dialogs.MultipleFolderSelectionDialog;
import tern.eclipse.ide.ui.dialogs.OpenResourceDialog;
import tern.eclipse.ide.ui.viewers.TernScriptPathContentProvider;
import tern.eclipse.ide.ui.viewers.TernScriptPathLabelProvider;
import tern.scriptpath.ITernScriptPath;

public class TernScriptPathsBlock
extends AbstractTreeBlock {
    private Composite fControl;
    private final List<ITernScriptPath> ternScriptPaths = new ArrayList<ITernScriptPath>();
    private TreeViewer treeViewer;
    private Button addFileButton;
    private Button addFolderButton;
    private Button addProjectButton;
    private Button removeButton;
    private final IIDETernProject ternProject;

    public TernScriptPathsBlock(IIDETernProject project) {
        this.ternProject = project;
    }

    public void createControl(Composite ancestor) {
        Composite parent = new Composite(ancestor, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        parent.setLayout((Layout)layout);
        Font font = ancestor.getFont();
        parent.setFont(font);
        this.fControl = parent;
        Label treeLabel = new Label(parent, 0);
        treeLabel.setText(TernUIMessages.TernScriptPathsBlock_desc);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        treeLabel.setLayoutData((Object)data);
        treeLabel.setFont(font);
        Tree tree = new Tree(parent, 68098);
        data = new GridData(1808);
        data.widthHint = 450;
        tree.setLayoutData((Object)data);
        tree.setFont(font);
        tree.setHeaderVisible(false);
        tree.setLinesVisible(false);
        this.treeViewer = new TreeViewer(tree);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)TernScriptPathLabelProvider.getInstance());
        this.treeViewer.setContentProvider((IContentProvider)TernScriptPathContentProvider.getInstance());
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                boolean enabled = false;
                if (!selection.isEmpty()) {
                    for (Object element : selection) {
                        if (!(element instanceof ITernScriptPath) || ((ITernScriptPath)element).isExternal()) continue;
                        enabled = true;
                        break;
                    }
                }
                TernScriptPathsBlock.this.removeButton.setEnabled(enabled);
            }
        });
        tree.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.character == '\u007f' && event.stateMask == 0) {
                    TernScriptPathsBlock.this.removeScriptPaths();
                }
            }
        });
        Composite buttons = new Composite(parent, 0);
        buttons.setLayoutData((Object)new GridData(2));
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttons.setLayout((Layout)layout);
        buttons.setFont(font);
        this.addFileButton = this.createPushButton(buttons, TernUIMessages.Button_addFile);
        this.addFileButton.addListener(13, new Listener(){

            public void handleEvent(Event evt) {
                TernScriptPathsBlock.this.addScriptPath(ITernScriptPath.ScriptPathsType.FILE);
            }
        });
        this.addFileButton.setEnabled(true);
        this.addFolderButton = this.createPushButton(buttons, TernUIMessages.Button_addFolder);
        this.addFolderButton.addListener(13, new Listener(){

            public void handleEvent(Event evt) {
                TernScriptPathsBlock.this.addScriptPath(ITernScriptPath.ScriptPathsType.FOLDER);
            }
        });
        this.addFolderButton.setEnabled(true);
        this.addProjectButton = this.createPushButton(buttons, TernUIMessages.Button_addProject);
        this.addProjectButton.addListener(13, new Listener(){

            public void handleEvent(Event evt) {
                TernScriptPathsBlock.this.addScriptPath(ITernScriptPath.ScriptPathsType.PROJECT);
            }
        });
        this.addProjectButton.setEnabled(true);
        this.removeButton = this.createPushButton(buttons, TernUIMessages.Button_remove);
        this.removeButton.addListener(13, new Listener(){

            public void handleEvent(Event evt) {
                TernScriptPathsBlock.this.removeScriptPaths();
            }
        });
        this.removeButton.setEnabled(false);
        Label separator = new Label(buttons, 0);
        separator.setVisible(false);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1;
        gd.heightHint = 4;
        separator.setLayoutData((Object)gd);
        this.restoreColumnSettings();
    }

    protected void addScriptPath(ITernScriptPath.ScriptPathsType type) {
        SelectionDialog dialog = this.createDialog(type);
        if (dialog.open() != 0) {
            return;
        }
        ITernScriptPath firstExistingScriptPath = null;
        Object[] results = dialog.getResult();
        if (results != null && results.length > 0) {
            IResource resource = null;
            ITernScriptPath scriptPath = null;
            Object[] objectArray = results;
            int n = results.length;
            int n2 = 0;
            while (n2 < n) {
                Object result = objectArray[n2];
                resource = (IResource)result;
                scriptPath = this.getScriptPath(resource);
                if (scriptPath != null) {
                    if (firstExistingScriptPath == null) {
                        firstExistingScriptPath = scriptPath;
                    }
                } else {
                    String[] includesPattern = null;
                    String[] excludesPattern = null;
                    this.ternScriptPaths.add(this.ternProject.createScriptPath(resource, type, includesPattern, excludesPattern));
                }
                ++n2;
            }
            this.treeViewer.refresh();
            if (firstExistingScriptPath != null) {
                this.treeViewer.setSelection((ISelection)new StructuredSelection(firstExistingScriptPath));
            }
        }
    }

    public SelectionDialog createDialog(ITernScriptPath.ScriptPathsType type) {
        IProject project = this.ternProject.getProject();
        switch (type) {
            case FOLDER: {
                return this.createFolderDialog(project, false);
            }
            case FILE: {
                return new OpenResourceDialog(this.getShell(), true, (IContainer)project, 1);
            }
            case PROJECT: {
                return this.createFolderDialog(project, true);
            }
        }
        return null;
    }

    public SelectionDialog createFolderDialog(final IProject project, final boolean showAllProjects) {
        WorkbenchLabelProvider lp = new WorkbenchLabelProvider();
        WorkbenchContentProvider cp = new WorkbenchContentProvider();
        MultipleFolderSelectionDialog dialog = new MultipleFolderSelectionDialog(this.getShell(), (ILabelProvider)lp, (ITreeContentProvider)cp, !showAllProjects);
        if (showAllProjects) {
            dialog.setInput(ResourcesPlugin.getWorkspace().getRoot());
        } else {
            dialog.setInput(project.getParent());
        }
        dialog.setInitialFocus(project);
        ViewerFilter filter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (showAllProjects) {
                    if (element instanceof IProject) {
                        IProject p = (IProject)element;
                        return !p.equals((Object)project) && TernCorePlugin.hasTernNature((IProject)p);
                    }
                } else if (element instanceof IContainer) {
                    IContainer container = (IContainer)element;
                    if (container.getType() == 2) {
                        return true;
                    }
                    if (container.getType() == 4) {
                        return project.equals((Object)container);
                    }
                    return false;
                }
                return false;
            }
        };
        dialog.addFilter(filter);
        return dialog;
    }

    private ITernScriptPath getScriptPath(IResource resource) {
        for (ITernScriptPath scriptPath : this.ternScriptPaths) {
            if (!resource.equals(scriptPath.getAdapter(IResource.class))) continue;
            return scriptPath;
        }
        return null;
    }

    protected void removeScriptPaths() {
        IStructuredSelection selection = (IStructuredSelection)this.treeViewer.getSelection();
        if (!selection.isEmpty()) {
            this.ternScriptPaths.removeAll(selection.toList());
            this.treeViewer.refresh();
        }
    }

    private Shell getShell() {
        return this.fControl.getShell();
    }

    public Control getControl() {
        return this.fControl;
    }

    public void setTernScriptPaths(Collection<ITernScriptPath> ternScriptPaths) {
        this.ternScriptPaths.clear();
        this.ternScriptPaths.addAll(ternScriptPaths);
        this.treeViewer.setInput(this.ternScriptPaths);
    }

    public List<ITernScriptPath> getTernScriptPaths() {
        return this.ternScriptPaths;
    }

    @Override
    protected Tree getTree() {
        return this.treeViewer.getTree();
    }

    @Override
    protected IDialogSettings getDialogSettings() {
        return TernUIPlugin.getDefault().getDialogSettings();
    }

    @Override
    protected String getQualifier() {
        return "tern.eclipse.ide.ui";
    }

    protected Button createPushButton(Composite parent, String label) {
        Button button = new Button(parent, 8);
        button.setText(label);
        button.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        return button;
    }
}

