/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.ui.contentassist;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import tern.ITernFile;
import tern.ITernProject;
import tern.eclipse.ide.ui.TernUIPlugin;
import tern.eclipse.ide.ui.contentassist.JSTernCompletionProposal;
import tern.server.protocol.IJSONObjectHelper;
import tern.server.protocol.completions.ITernCompletionCollector;
import tern.server.protocol.completions.TernCompletionProposalRec;

public class JSTernCompletionCollector
implements ITernCompletionCollector {
    protected final List<ICompletionProposal> proposals;
    private boolean generateAnonymousFunction;
    private boolean expandFunction;
    private String indentChars;
    private final ITernFile ternFile;
    private final ITernProject ternProject;

    public JSTernCompletionCollector(List<ICompletionProposal> proposals, int startOffset, ITernFile ternFile, ITernProject ternProject) {
        this.proposals = proposals;
        this.ternFile = ternFile;
        this.ternProject = ternProject;
        IPreferencesService preferencesService = Platform.getPreferencesService();
        IProject project = (IProject)ternProject.getAdapter(IProject.class);
        IScopeContext[] lookupOrder = project != null ? new IScopeContext[]{new ProjectScope(project), InstanceScope.INSTANCE, DefaultScope.INSTANCE} : new IScopeContext[]{InstanceScope.INSTANCE, DefaultScope.INSTANCE};
        this.generateAnonymousFunction = preferencesService.getBoolean(TernUIPlugin.getDefault().getBundle().getSymbolicName(), "generate-anonymous-function-contentassist", true, lookupOrder);
        int indentSize = preferencesService.getInt(TernUIPlugin.getDefault().getBundle().getSymbolicName(), "indent-size-contentassist", 1, lookupOrder);
        boolean indentWithTabs = preferencesService.getBoolean(TernUIPlugin.getDefault().getBundle().getSymbolicName(), "indent-tabs-contentassist", true, lookupOrder);
        this.indentChars = this.getIndentChars(indentWithTabs, indentSize);
        this.expandFunction = preferencesService.getBoolean(TernUIPlugin.getDefault().getBundle().getSymbolicName(), "expand-function-contentassist", true, lookupOrder);
    }

    private String getIndentChars(boolean indentWithTabs, int indentSize) {
        StringBuilder indent = new StringBuilder();
        int i = 0;
        while (i < indentSize) {
            indent.append(indentWithTabs ? "\t" : " ");
            ++i;
        }
        return indent.toString();
    }

    public void addProposal(TernCompletionProposalRec proposalItem, Object completion, IJSONObjectHelper jsonObjectHelper) {
        String[] functions;
        JSTernCompletionProposal proposal = this.internalCreateProposal(proposalItem);
        if (proposal.isFunction()) {
            this.proposals.add((ICompletionProposal)this.internalCreateProposal(proposalItem.changeType("fn")));
        }
        this.proposals.add((ICompletionProposal)proposal);
        if (this.expandFunction && (functions = proposal.expand()) != null) {
            int i = 0;
            while (i < functions.length) {
                this.proposals.add((ICompletionProposal)this.internalCreateProposal(proposalItem.changeType(functions[i])));
                ++i;
            }
        }
    }

    private JSTernCompletionProposal internalCreateProposal(TernCompletionProposalRec proposalItem) {
        JSTernCompletionProposal proposal = this.createProposal(proposalItem);
        proposal.setGenerateAnonymousFunction(this.generateAnonymousFunction);
        proposal.setIndentChars(this.indentChars);
        proposal.setGenerateObjectValue(true);
        proposal.setTernFile(this.ternFile);
        proposal.setTernProject(this.ternProject);
        return proposal;
    }

    protected JSTernCompletionProposal createProposal(TernCompletionProposalRec proposalItem) {
        return new JSTernCompletionProposal(proposalItem);
    }
}

