/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.ui.contentassist;

import java.util.List;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import tern.ITernFile;
import tern.ITernProject;
import tern.eclipse.ide.ui.contentassist.JSTernCompletionCollector;
import tern.eclipse.ide.ui.contentassist.TimeoutProposal;
import tern.server.protocol.IJSONObjectHelper;
import tern.server.protocol.ITernResultsAsyncCollector;
import tern.server.protocol.completions.TernCompletionProposalRec;

public class JSTernCompletionAsyncCollector
extends JSTernCompletionCollector
implements ITernResultsAsyncCollector {
    private boolean timedOut;
    private boolean contentAdded;
    private int startOffset;

    public JSTernCompletionAsyncCollector(List<ICompletionProposal> proposals, int startOffset, ITernFile ternFile, ITernProject project) {
        super(proposals, startOffset, ternFile, project);
        this.startOffset = startOffset;
    }

    @Override
    public void addProposal(TernCompletionProposalRec proposal, Object completion, IJSONObjectHelper jsonObjectHelper) {
        if (!this.timedOut) {
            this.contentAdded = true;
            super.addProposal(proposal, completion, jsonObjectHelper);
        }
    }

    public void done() {
        if (!this.timedOut) {
            this.contentAdded = true;
        }
    }

    public String getRequestDisplayName() {
        return "Calculating completion proposals...";
    }

    public void timeout(ITernResultsAsyncCollector.TimeoutReason reason) {
        this.timedOut = true;
        if (!this.contentAdded) {
            this.proposals.add(this.createTimeoutProposal(this.startOffset, reason));
        }
    }

    protected ICompletionProposal createTimeoutProposal(int startOffset, ITernResultsAsyncCollector.TimeoutReason reason) {
        return new TimeoutProposal(startOffset, reason);
    }
}

