/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.ui;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import tern.eclipse.ide.internal.ui.Trace;
import tern.eclipse.ide.ui.TernUIPlugin;

public class ImageResource {
    private static ImageRegistry imageRegistry;
    private static Map<String, ImageDescriptor> imageDescriptors;
    private static URL ICON_BASE_URL;
    private static final String URL_DLCL = "full/dlcl16/";
    private static final String URL_ELCL = "full/elcl16/";
    private static final String URL_OBJ = "full/obj16/";
    public static final String IMG_SCRIPT = "script";
    public static final String IMG_LOGO = "logo";
    public static final String IMG_PLUGIN = "plugin";
    public static final String IMG_TYPE_DEF = "typedef";
    public static final String IMG_STOP_ENABLED = "stop_enabled";
    public static final String IMG_STOP_DISABLED = "stop_disabled";

    static {
        try {
            String pathSuffix = "icons/";
            ICON_BASE_URL = TernUIPlugin.getDefault().getBundle().getEntry(pathSuffix);
        }
        catch (Exception e) {
            Trace.trace((byte)3, "Images error", e);
        }
    }

    private ImageResource() {
    }

    protected static void dispose() {
    }

    public static Image getImage(String key) {
        return ImageResource.getImage(key, null);
    }

    public static Image getImage(String key, String keyIfImageNull) {
        Image image;
        if (imageRegistry == null) {
            ImageResource.initializeImageRegistry();
        }
        if ((image = imageRegistry.get(key)) == null) {
            if (keyIfImageNull != null) {
                return ImageResource.getImage(keyIfImageNull, null);
            }
            imageRegistry.put(key, ImageDescriptor.getMissingImageDescriptor());
            image = imageRegistry.get(key);
        }
        return image;
    }

    public static ImageDescriptor getImageDescriptor(String key) {
        ImageDescriptor id;
        if (imageRegistry == null) {
            ImageResource.initializeImageRegistry();
        }
        if ((id = imageDescriptors.get(key)) != null) {
            return id;
        }
        return ImageDescriptor.getMissingImageDescriptor();
    }

    protected static void initializeImageRegistry() {
        imageRegistry = TernUIPlugin.getDefault().getImageRegistry();
        imageDescriptors = new HashMap<String, ImageDescriptor>();
        ImageResource.registerImage(IMG_SCRIPT, "full/obj16/script.gif");
        ImageResource.registerImage(IMG_LOGO, "full/obj16/logo.png");
        ImageResource.registerImage(IMG_PLUGIN, "full/obj16/plugin.gif");
        ImageResource.registerImage(IMG_TYPE_DEF, "full/obj16/typedef.gif");
        ImageResource.registerImage(IMG_STOP_ENABLED, "full/elcl16/launch_stop.gif");
        ImageResource.registerImage(IMG_STOP_DISABLED, "full/dlcl16/launch_stop.gif");
    }

    public static void registerImage(String key, String partialURL) {
        try {
            ImageDescriptor id = ImageDescriptor.createFromURL((URL)new URL(ICON_BASE_URL, partialURL));
            ImageResource.registerImageDescriptor(key, id);
        }
        catch (Exception e) {
            Trace.trace((byte)3, "Error registering image " + key + " from " + partialURL, e);
        }
    }

    public static void registerImageDescriptor(String key, ImageDescriptor id) {
        if (imageRegistry == null) {
            ImageResource.initializeImageRegistry();
        }
        imageRegistry.put(key, id);
        imageDescriptors.put(key, id);
    }
}

