/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.internal.ui.preferences;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import tern.eclipse.ide.core.IIDETernRepository;
import tern.eclipse.ide.core.TernCorePlugin;
import tern.eclipse.ide.core.preferences.TernCorePreferenceConstants;
import tern.eclipse.ide.internal.ui.TernUIMessages;
import tern.eclipse.ide.ui.ImageResource;
import tern.eclipse.ide.ui.controls.TernRepositoryBlock;
import tern.eclipse.ide.ui.preferences.PropertyPreferencePage;
import tern.repository.ITernRepository;

public class TernRepositoryPreferencesPage
extends PropertyPreferencePage {
    public static final String PROPERTY_PAGE_ID = "tern.eclipse.ide.ui.properties.repository";
    public static final String PREFERENCE_PAGE_ID = "tern.eclipse.ide.ui.preferences.repository";
    private TernRepositoryBlock repositoryBlock;
    private Button removeButton;
    private Button editButton;
    private Button refreshButton;

    public TernRepositoryPreferencesPage() {
        this.setImageDescriptor(ImageResource.getImageDescriptor("logo"));
    }

    @Override
    protected Control createCommonContents(Composite parent) {
        Composite page = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        page.setLayout((Layout)layout);
        this.createRepositoryTable(page);
        this.createButtons(page);
        this.addListeners();
        this.repositoryBlock.loadRepositories();
        this.applyDialogFont(page);
        return page;
    }

    private void createRepositoryTable(Composite parent) {
        this.repositoryBlock = new TernRepositoryBlock(this.getProject());
        Control control = this.repositoryBlock.createControl(parent);
        GridData data = new GridData(1808);
        data.horizontalSpan = 1;
        control.setLayoutData((Object)data);
    }

    private void createButtons(final Composite parent) {
        Composite buttonComp = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(3);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 1;
        buttonComp.setLayout((Layout)layout);
        GridData data = new GridData(272);
        buttonComp.setLayoutData((Object)data);
        Button addButton = TernRepositoryPreferencesPage.createButton(buttonComp, TernUIMessages.Button_add);
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TernRepositoryPreferencesPage.this.repositoryBlock.addRepository(parent.getShell());
            }
        });
        this.removeButton = TernRepositoryPreferencesPage.createButton(buttonComp, TernUIMessages.Button_remove);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TernRepositoryPreferencesPage.this.repositoryBlock.removeRepository(parent.getShell());
            }
        });
        this.removeButton.setEnabled(false);
        this.editButton = TernRepositoryPreferencesPage.createButton(buttonComp, TernUIMessages.Button_edit);
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TernRepositoryPreferencesPage.this.repositoryBlock.editRepository(parent.getShell());
            }
        });
        this.editButton.setEnabled(false);
        this.refreshButton = TernRepositoryPreferencesPage.createButton(buttonComp, TernUIMessages.Button_refresh);
        this.refreshButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TernRepositoryPreferencesPage.this.repositoryBlock.refreshRepository();
            }
        });
        this.refreshButton.setEnabled(false);
    }

    private static Button createButton(Composite comp, String label) {
        Button b = new Button(comp, 8);
        b.setText(label);
        GridData data = new GridData(258);
        b.setLayoutData((Object)data);
        return b;
    }

    private void addListeners() {
        this.repositoryBlock.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (!selection.isEmpty()) {
                    ITernRepository repository = (ITernRepository)selection.getFirstElement();
                    TernRepositoryPreferencesPage.this.removeButton.setEnabled(!repository.isDefault());
                    TernRepositoryPreferencesPage.this.editButton.setEnabled(!repository.isDefault());
                    TernRepositoryPreferencesPage.this.refreshButton.setEnabled(true);
                }
            }
        });
    }

    @Override
    protected void performDefaults() {
        super.performDefaults();
        IEclipsePreferences defaultPreferences = this.createPreferenceScopes()[1].getNode(this.getPreferenceNodeQualifier());
        String repositoryName = defaultPreferences.get("used-repository-name", "default");
        IIDETernRepository repository = TernCorePlugin.getTernRepositoryManager().getRepository(repositoryName);
        this.repositoryBlock.setCheckedRepository(repository);
        this.repositoryBlock.setCheckedModules(TernCorePreferenceConstants.DEFAULT_TERN_MODULES_VALUE.split(","));
    }

    @Override
    public boolean performOk() {
        boolean remove;
        this.repositoryBlock.saveColumnSettings();
        this.repositoryBlock.saveRepositories();
        boolean ok = super.performOk();
        ITernRepository repository = this.repositoryBlock.getCheckedRepository();
        IScopeContext[] contexts = this.createPreferenceScopes();
        IProject project = this.getProject();
        boolean bl = remove = project != null && !this.isElementSettingsEnabled();
        if (remove) {
            contexts[0].getNode(this.getPreferenceNodeQualifier()).remove("used-repository-name");
        } else {
            contexts[0].getNode(this.getPreferenceNodeQualifier()).put("used-repository-name", repository.getName());
        }
        this.flushContexts(contexts);
        return ok;
    }

    @Override
    protected String getPreferenceNodeQualifier() {
        return TernCorePlugin.getDefault().getBundle().getSymbolicName();
    }

    @Override
    protected String getPreferencePageID() {
        return PREFERENCE_PAGE_ID;
    }

    @Override
    protected String getProjectSettingsKey() {
        return "repository-use-project-settings";
    }

    @Override
    protected String getPropertyPageID() {
        return PROPERTY_PAGE_ID;
    }

    public void init(IWorkbench workbencsh) {
    }
}

