/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.core.preferences;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.jboss.tools.openshift.core.preferences.OpenShiftCorePreferences;
import org.jboss.tools.openshift.internal.common.core.util.CommandLocationBinary;

public enum OCBinary {
    WINDOWS("oc.exe", new String[]{"exe"}),
    OTHER("oc", new String[0]);

    private static final String OC_DEFAULTLOCATION_LINUX = "/usr/bin/oc";
    private String name;
    private String[] extensions;
    private CommandLocationBinary locationBinary;

    public static OCBinary getInstance() {
        if (SystemUtils.IS_OS_WINDOWS) {
            return WINDOWS;
        }
        return OTHER;
    }

    private OCBinary(String name, String[] extensions) {
        this.name = name;
        this.extensions = extensions;
    }

    public String getName() {
        return this.name;
    }

    public String[] getExtensions() {
        return this.extensions;
    }

    public String getSystemPathLocation() {
        if (this.locationBinary == null) {
            this.locationBinary = new CommandLocationBinary("oc");
            this.locationBinary.addPlatformLocation("linux", OC_DEFAULTLOCATION_LINUX);
            this.locationBinary.setDefaultPlatform("linux");
        }
        return this.locationBinary.findLocation();
    }

    public String getLocation() {
        String location = OpenShiftCorePreferences.INSTANCE.getOCBinaryLocation();
        if (StringUtils.isBlank((String)location)) {
            location = this.getSystemPathLocation();
        }
        return location;
    }
}

