/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.core;

import com.openshift.restclient.IClient;
import com.openshift.restclient.IOpenShiftWatchListener;
import com.openshift.restclient.IWatcher;
import com.openshift.restclient.capability.CapabilityVisitor;
import com.openshift.restclient.capability.resources.IClientCapability;
import com.openshift.restclient.model.IProject;
import com.openshift.restclient.model.IResource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.jboss.tools.openshift.common.core.connection.ConnectionsRegistrySingleton;
import org.jboss.tools.openshift.common.core.connection.IConnection;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.core.connection.ConnectionsRegistryUtil;
import org.jboss.tools.openshift.internal.core.Trace;

public class WatchManager {
    private static final int[] FIBONACCI;
    private static final long BACKOFF_MILLIS = 5000L;
    private static final long BACKOFF_RESET;
    private static final String[] KINDS;
    private Map<IProject, IWatcher> watches = Collections.synchronizedMap(new HashMap());

    static {
        int[] nArray = new int[9];
        nArray[1] = 1;
        nArray[2] = 1;
        nArray[3] = 2;
        nArray[4] = 3;
        nArray[5] = 5;
        nArray[6] = 8;
        nArray[7] = 13;
        nArray[8] = 21;
        FIBONACCI = nArray;
        BACKOFF_RESET = (long)FIBONACCI[FIBONACCI.length - 1] * 5000L * 2L;
        KINDS = new String[]{"BuildConfig", "DeploymentConfig", "Service", "Pod", "ReplicationController", "Build", "ImageStream", "Route"};
    }

    public static WatchManager getInstance() {
        return Holder.instance;
    }

    public void stopWatch(IProject project) {
        if (this.watches.containsKey(project)) {
            this.watches.remove(project).stop();
        }
    }

    public void startWatch(IProject project) {
        if (!this.watches.containsKey(project)) {
            this.startWatch(project, 0, 0L);
        }
    }

    private void startWatch(IProject project, int backoff, long lastConnect) {
        Connection conn = ConnectionsRegistryUtil.getConnectionFor((IResource)project);
        WatchListener listener = new WatchListener(project, conn, backoff, lastConnect);
        listener.start();
    }

    private static class Holder {
        static WatchManager instance = new WatchManager();

        private Holder() {
        }
    }

    private static enum State {
        STARTING,
        CONNECTED,
        DISCONNECTED;

    }

    private class WatchListener
    implements IOpenShiftWatchListener {
        private static final int NOT_FOUND = -1;
        private final Connection conn;
        private final IProject project;
        private int backoff = 0;
        private long lastConnect = 0L;
        private AtomicReference<State> state = new AtomicReference<State>(State.DISCONNECTED);
        private List<IResource> resources = Collections.synchronizedList(new ArrayList());

        public WatchListener(IProject project, Connection conn, int backoff, long lastConnect) {
            Trace.debug("Adding WatchListener for {0}", project.getName());
            this.project = project;
            this.conn = conn;
            this.backoff = backoff;
            this.lastConnect = lastConnect;
            if (System.currentTimeMillis() - lastConnect > BACKOFF_RESET) {
                backoff = 0;
            }
            Trace.debug("Initial watch backoff of {0} ms", (long)FIBONACCI[backoff] * 5000L);
        }

        public void connected(List<IResource> resources) {
            Trace.debug("Endpoint connected to {0} with {1} resources", this.conn.toString(), resources.size());
            this.resources.addAll(resources);
        }

        public void disconnected() {
            Trace.debug("Endpoint disconnected to {0}.", this.conn.toString());
            this.restart();
        }

        public void error(Throwable err) {
            Trace.warn("Reconnecting. There was an error watching connection {0}:", err, this.conn.toString());
            this.restart();
        }

        private synchronized void restart() {
            if (this.state.get() == State.DISCONNECTED) {
                Trace.debug("Restart called but returning early because already disconnected", new Object[0]);
                return;
            }
            this.state.set(State.DISCONNECTED);
            Trace.debug("Rescheduling watch job for project {0}", this.project.getName());
            WatchManager.this.startWatch(this.project, this.backoff, this.lastConnect);
        }

        public void start() {
            if (this.state.get() == State.STARTING) {
                Trace.debug("In the process of starting watch already.  Returning early", new Object[0]);
                return;
            }
            this.state.set(State.STARTING);
            Trace.info("Starting watch on project {0}", this.project.getName());
            IClient client = this.getClientFor(this.project);
            if (client != null) {
                new RestartWatchJob(client).schedule();
            }
        }

        private void connect(IClient client) {
            WatchManager.this.watches.put(this.project, client.watch(this.project.getName(), (IOpenShiftWatchListener)this, KINDS));
            this.state.set(State.CONNECTED);
            this.lastConnect = System.currentTimeMillis();
        }

        private IClient getClientFor(IProject project) {
            IClient client = (IClient)project.accept((CapabilityVisitor)new CapabilityVisitor<IClientCapability, IClient>(){

                public IClient visit(IClientCapability cap) {
                    return cap.getClient();
                }
            }, null);
            if (client == null) {
                Trace.warn("Unable to start watch.  Project {0} does not support IClientCapability", null, project.getName());
            }
            return client;
        }

        public void received(IResource resource, IOpenShiftWatchListener.ChangeType change) {
            Trace.debug("Watch received change\n{0}", resource.toJson(false));
            IResource newItem = null;
            IResource oldItem = null;
            int index = this.resources.indexOf(resource);
            switch (change) {
                case ADDED: {
                    this.resources.add(resource);
                    newItem = resource;
                    break;
                }
                case DELETED: {
                    oldItem = index > -1 ? this.resources.remove(index) : resource;
                    break;
                }
                case MODIFIED: {
                    if (index > -1) {
                        oldItem = this.resources.remove(index);
                    }
                    this.resources.add(resource);
                    newItem = resource;
                }
            }
            ConnectionsRegistrySingleton.getInstance().fireConnectionChanged((IConnection)this.conn, "openshift.resource", (Object)oldItem, (Object)newItem);
        }

        private class RestartWatchJob
        extends Job {
            private IClient client;

            RestartWatchJob(IClient client) {
                super("");
                this.client = client;
            }

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    WatchListener.this.connect(this.client);
                }
                catch (Exception e) {
                    Trace.debug("Exception starting watch on project {0}", e, WatchListener.this.project.getName());
                    WatchListener watchListener = WatchListener.this;
                    watchListener.backoff = watchListener.backoff + 1;
                    if (WatchListener.this.backoff >= FIBONACCI.length) {
                        Trace.info("Exceeded backoff attempts trying to reconnect watch for {0}", WatchListener.this.project.getName());
                        WatchManager.this.watches.remove(WatchListener.this.project);
                        WatchListener.this.state.set(State.DISCONNECTED);
                        return Status.OK_STATUS;
                    }
                    long delay = (long)FIBONACCI[WatchListener.this.backoff] * 5000L;
                    Trace.debug("Delaying watch restart by {0}ms", delay);
                    new RestartWatchJob(this.client).schedule(delay);
                }
                return Status.OK_STATUS;
            }
        }
    }
}

