/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.core.server;

import com.openshift.restclient.OpenShiftContext;
import com.openshift.restclient.OpenShiftException;
import com.openshift.restclient.capability.CapabilityVisitor;
import com.openshift.restclient.capability.resources.IRSyncable;
import com.openshift.restclient.model.IPod;
import com.openshift.restclient.model.IService;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.server.core.IServer;
import org.jboss.tools.openshift.core.server.OCBinaryOperation;
import org.jboss.tools.openshift.internal.core.preferences.OCBinary;

public class RSync
extends OCBinaryOperation {
    private IService service;
    private String podPath;
    private IServer server;

    public RSync(IService service, String podPath, IServer server) {
        this.service = service;
        this.podPath = RSync.sanitizePath(podPath);
        this.server = server;
    }

    private static String sanitizePath(String path) {
        if (path == null) {
            return null;
        }
        if (path.endsWith("/") || path.endsWith("/.")) {
            return path;
        }
        return String.valueOf(path) + "/";
    }

    public void syncPodsToDirectory(File deployFolder, MultiStatus status) {
        String location = OCBinary.getInstance().getLocation();
        OpenShiftContext.get().put("openshift.restclient.oc.location", (Object)location);
        boolean shouldSync = true;
        if (shouldSync) {
            for (IPod pod : this.service.getPods()) {
                try {
                    this.syncPodToDirectory(pod, this.podPath, deployFolder);
                }
                catch (OpenShiftException | IOException e) {
                    status.add((IStatus)new Status(4, "org.jboss.tools.openshift.core", e.getMessage()));
                }
            }
        }
    }

    public void syncDirectoryToPods(File deployFolder, MultiStatus status) {
        String location = OCBinary.getInstance().getLocation();
        OpenShiftContext.get().put("openshift.restclient.oc.location", (Object)location);
        for (IPod pod : this.service.getPods()) {
            try {
                this.syncDirectoryToPod(pod, deployFolder, this.podPath);
            }
            catch (OpenShiftException | IOException e) {
                status.add((IStatus)new Status(4, "org.jboss.tools.openshift.core", e.getMessage()));
            }
        }
    }

    @Override
    @Deprecated
    protected void runOCBinary(MultiStatus status) {
    }

    private void syncPodToDirectory(final IPod pod, final String podPath, File destination) throws IOException {
        destination.mkdirs();
        final String destinationPath = RSync.sanitizePath(destination.getAbsolutePath());
        pod.accept((CapabilityVisitor)new CapabilityVisitor<IRSyncable, IRSyncable>(){

            public IRSyncable visit(IRSyncable rsyncable) {
                rsyncable.sync((IRSyncable.Peer)new IRSyncable.PodPeer(podPath, pod), (IRSyncable.Peer)new IRSyncable.LocalPeer(destinationPath));
                return rsyncable;
            }
        }, null);
    }

    private void syncDirectoryToPod(final IPod pod, File source, final String podPath) throws IOException {
        final String sourcePath = RSync.sanitizePath(source.getAbsolutePath());
        pod.accept((CapabilityVisitor)new CapabilityVisitor<IRSyncable, IRSyncable>(){

            public IRSyncable visit(IRSyncable rsyncable) {
                rsyncable.sync((IRSyncable.Peer)new IRSyncable.LocalPeer(sourcePath), (IRSyncable.Peer)new IRSyncable.PodPeer(podPath, pod));
                return rsyncable;
            }
        }, null);
    }
}

