/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.core.server;

import com.openshift.restclient.model.IService;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.stream.Stream;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jst.j2ee.internal.deployables.BinaryFileModuleDelegate;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.model.ModuleDelegate;
import org.eclipse.wst.server.core.util.ProjectModule;
import org.jboss.ide.eclipse.as.core.modules.ResourceModuleResourceUtil;
import org.jboss.ide.eclipse.as.core.server.IModulePathFilter;
import org.jboss.ide.eclipse.as.core.server.IModulePathFilterProvider;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.LocalFilesystemController;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.util.PublishControllerUtil;
import org.jboss.ide.eclipse.as.wtp.core.server.publish.LocalZippedModulePublishRunner;
import org.jboss.ide.eclipse.as.wtp.core.util.ServerModelUtilities;
import org.jboss.tools.as.core.internal.modules.ModuleDeploymentPrefsUtil;
import org.jboss.tools.common.util.FileUtils;
import org.jboss.tools.openshift.common.core.utils.ProjectUtils;
import org.jboss.tools.openshift.common.core.utils.StringUtils;
import org.jboss.tools.openshift.core.server.OpenShiftServerUtils;
import org.jboss.tools.openshift.core.server.RSync;
import org.jboss.tools.openshift.internal.core.OpenShiftCoreActivator;
import org.jboss.tools.openshift.internal.core.preferences.OCBinary;
import org.jboss.tools.runtime.core.extract.ExtractUtility;
import org.jboss.tools.runtime.core.extract.IOverwrite;

public class OpenShiftServerPublishMethod {
    private RSync rsync = null;

    public void publishStart(IServer server, IProgressMonitor monitor) throws CoreException {
        IProject deployProject = this.getMagicProject(server);
        if (!ProjectUtils.isAccessible((IProject)deployProject)) {
            throw new CoreException((IStatus)new Status(4, "org.jboss.tools.openshift.core", NLS.bind((String)"Server adapter {0} cannot publish. Required project {1} is missing or inaccessible.", (Object)server.getName(), (Object)deployProject.getName())));
        }
        this.rsync = this.createRSync(server, monitor);
        File localDeploymentDirectory = this.getLocalDeploymentDirectory(server);
        MultiStatus status = new MultiStatus("org.jboss.tools.openshift.core", 0, NLS.bind((String)"Could not sync all pods to folder {0}", (Object)localDeploymentDirectory.getAbsolutePath()), null);
        this.rsync.syncPodsToDirectory(localDeploymentDirectory, status);
        if (!this.modulesIncludesMagicProject(server, deployProject)) {
            IModule projectModule = this.findProjectModule(deployProject);
            if (projectModule == null) {
                this.publishMagicProjectSimpleCopy(server, localDeploymentDirectory);
            } else {
                this.publishModule(server, new IModule[]{projectModule}, 2, monitor);
            }
        }
    }

    private IModule findProjectModule(IServer s) {
        IProject deployProject = this.getMagicProject(s);
        return this.findProjectModule(deployProject);
    }

    private IModule findProjectModule(IProject p) {
        IModule[] all = ServerUtil.getModules((IProject)p);
        int i = 0;
        while (i < all.length) {
            ModuleDelegate md = (ModuleDelegate)all[i].loadAdapter(ModuleDelegate.class, (IProgressMonitor)new NullProgressMonitor());
            if (md instanceof ProjectModule && !(md instanceof BinaryFileModuleDelegate)) {
                return all[i];
            }
            ++i;
        }
        return null;
    }

    public static IPath getModuleNestedDeployPath(IModule[] moduleTree, String rootFolder, IServer server) {
        return new ModuleDeploymentPrefsUtil().getModuleNestedDeployPath(moduleTree, rootFolder, (IServerAttributes)server);
    }

    private LocalZippedModulePublishRunner createZippedRunner(IServer server, IModule m, IPath p) {
        return new LocalZippedModulePublishRunner(server, m, p, this.getModulePathFilterProvider());
    }

    private IModulePathFilterProvider getModulePathFilterProvider() {
        return new IModulePathFilterProvider(){

            public IModulePathFilter getFilter(IServer server, IModule[] module) {
                return ResourceModuleResourceUtil.findDefaultModuleFilter((IModule)module[module.length - 1]);
            }
        };
    }

    private void publishMagicProjectSimpleCopy(IServer server, File localDeploymentDirectory) throws CoreException {
        String sourcePath = OpenShiftServerUtils.getSourcePath((IServerAttributes)server);
        if (StringUtils.isEmpty((String)sourcePath)) {
            throw new CoreException(OpenShiftCoreActivator.statusFactory().errorStatus(NLS.bind((String)"Server {0} could not determine the source to publish.", (Object)server.getName())));
        }
        File source = new File(sourcePath);
        FileUtils.copyDir((File)source, (File)localDeploymentDirectory, (boolean)true, (boolean)true, (boolean)true, (FileFilter)new FileFilter(){

            @Override
            public boolean accept(File file) {
                String filename = file.getName();
                return !filename.endsWith(".git") && !filename.endsWith(".gitignore") && !filename.endsWith(".svn") && !filename.endsWith(".settings") && !filename.endsWith(".project") && !filename.endsWith(".classpath");
            }
        });
    }

    private boolean modulesIncludesMagicProject(IServer server, IProject deployProject) {
        IModule[] all = server.getModules();
        if (all != null) {
            int i = 0;
            while (i < all.length) {
                if (all[i].getProject().equals((Object)deployProject)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private IProject getMagicProject(IServer server) {
        String deployProjectName = OpenShiftServerUtils.getDeployProjectName((IServerAttributes)server);
        return ProjectUtils.getProject((String)deployProjectName);
    }

    private RSync createRSync(IServer server, IProgressMonitor monitor) throws CoreException {
        String location = OCBinary.getInstance().getLocation();
        if (location == null) {
            throw new CoreException(OpenShiftCoreActivator.statusFactory().errorStatus("Binary for oc-tools could not be found. Please open the OpenShift 3 Preference Page and set the location of the oc binary."));
        }
        IService service = OpenShiftServerUtils.getService((IServerAttributes)server);
        if (service == null) {
            throw new CoreException(OpenShiftCoreActivator.statusFactory().errorStatus(NLS.bind((String)"Server {0} could not determine the service to publish to.", (Object)server.getName())));
        }
        String podPath = OpenShiftServerUtils.getPodPath((IServerAttributes)server);
        if (StringUtils.isEmpty((String)podPath)) {
            throw new CoreException(OpenShiftCoreActivator.statusFactory().errorStatus(NLS.bind((String)"Server {0} could not determine the destination directory to publish to.", (Object)server.getName())));
        }
        return new RSync(service, podPath, server);
    }

    public int publishFinish(IServer server, IProgressMonitor monitor) throws CoreException {
        try {
            if (this.rsync != null) {
                File deployFolder = this.getLocalDeploymentDirectory(server);
                IService service = OpenShiftServerUtils.getService((IServerAttributes)server);
                MultiStatus status = new MultiStatus("org.jboss.tools.openshift.core", 0, NLS.bind((String)"Could not sync {0} to all pods running the service {1}", (Object)deployFolder, (Object)service.getName()), null);
                this.rsync.syncDirectoryToPods(deployFolder, status);
                Stream.of(deployFolder.listFiles()).filter(p -> p.getName().endsWith(".dodeploy")).forEach(p -> {
                    boolean bl = p.delete();
                });
                int n = status.isOK() ? 1 : 2;
                return n;
            }
            return 1;
        }
        finally {
            this.rsync = null;
        }
    }

    public int publishModule(IServer server, int kind, int deltaKind, IModule[] module, IProgressMonitor monitor) throws CoreException {
        if (module.length > 1) {
            return 1;
        }
        int publishType = PublishControllerUtil.getPublishType((IServer)server, (IModule[])module, (int)kind, (int)deltaKind);
        if (publishType != 0) {
            if (publishType == 3) {
                return this.removeModule(server, module, monitor);
            }
            return this.publishModule(server, module, publishType, monitor);
        }
        return 1;
    }

    protected int removeModule(IServer server, IModule[] module, IProgressMonitor monitor) throws CoreException {
        IStatus s;
        String suffix;
        IModule projectModule = this.findProjectModule(server);
        File localDeploymentDirectory = this.getLocalDeploymentDirectory(server);
        IPath outputFileFullPath = new ModuleDeploymentPrefsUtil().getModuleNestedDeployPath(module, localDeploymentDirectory.getAbsolutePath(), (IServerAttributes)server);
        if (module[0].equals(projectModule) && new File(localDeploymentDirectory, "ROOT" + (suffix = ServerModelUtilities.getDefaultSuffixForModule((IModule)module[0]))).exists()) {
            outputFileFullPath = new Path(localDeploymentDirectory.getAbsolutePath()).append("ROOT" + suffix);
        }
        return (s = new LocalFilesystemController().deleteResource(outputFileFullPath, monitor)).isOK() ? 1 : 0;
    }

    protected int publishModule(IServer server, IModule[] module, int publishType, IProgressMonitor monitor) throws CoreException {
        String suffix;
        File localDeploymentDirectory = this.getLocalDeploymentDirectory(server);
        File tempDeploymentDirectory = this.getLocalTempDeploymentDirectory(server);
        IModule projectModule = this.findProjectModule(server);
        IPath outputFileFullPath = new ModuleDeploymentPrefsUtil().getModuleNestedDeployPath(module, tempDeploymentDirectory.getAbsolutePath(), (IServerAttributes)server);
        IPath unzipLocation = new ModuleDeploymentPrefsUtil().getModuleNestedDeployPath(module, localDeploymentDirectory.getAbsolutePath(), (IServerAttributes)server);
        if (module[0].equals(projectModule) && new File(localDeploymentDirectory, "ROOT" + (suffix = ServerModelUtilities.getDefaultSuffixForModule((IModule)module[0]))).exists()) {
            outputFileFullPath = new Path(tempDeploymentDirectory.getAbsolutePath()).append("ROOT" + suffix);
            unzipLocation = new Path(localDeploymentDirectory.getAbsolutePath()).append("ROOT" + suffix);
        }
        this.packageAndUnzip(server, module[0], outputFileFullPath, unzipLocation, monitor);
        if (publishType == 2) {
            IPath marker = unzipLocation.removeLastSegments(1).append(String.valueOf(unzipLocation.lastSegment()) + ".dodeploy");
            try {
                marker.toFile().createNewFile();
            }
            catch (IOException iOException) {}
        }
        return 1;
    }

    private int packageAndUnzip(IServer server, IModule module, IPath outputFileFullPath, IPath unzipLocation, IProgressMonitor monitor) throws CoreException {
        LocalZippedModulePublishRunner runner = this.createZippedRunner(server, module, outputFileFullPath);
        monitor.beginTask("Moving module to " + unzipLocation.lastSegment(), 100);
        runner.fullPublishModule((IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)20));
        if (unzipLocation.toFile().exists() && unzipLocation.toFile().isFile()) {
            unzipLocation.toFile().delete();
        }
        IOverwrite yes = new IOverwrite(){

            public int overwrite(File file) {
                return 1;
            }
        };
        new ExtractUtility(outputFileFullPath.toFile(), 1).extract(unzipLocation.toFile(), yes, monitor);
        return 1;
    }

    private File getLocalDeploymentDirectory(IServer server) {
        return org.jboss.ide.eclipse.as.core.util.ServerUtil.getServerStateLocation((IServer)server).append("deploy").toFile();
    }

    private File getLocalTempDeploymentDirectory(IServer server) {
        return org.jboss.ide.eclipse.as.core.util.ServerUtil.getServerStateLocation((IServer)server).append("tempDeploy").toFile();
    }
}

