/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.core.server;

import com.openshift.restclient.authorization.ResourceForbiddenException;
import com.openshift.restclient.model.IService;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.model.ServerBehaviourDelegate;
import org.jboss.tools.openshift.core.server.OpenShiftServerPublishMethod;
import org.jboss.tools.openshift.core.server.OpenShiftServerUtils;
import org.jboss.tools.openshift.internal.core.OpenShiftCoreActivator;

public class OpenShiftServerBehaviour
extends ServerBehaviourDelegate {
    private IAdaptable publishAdaptableInfo;
    private OpenShiftServerPublishMethod publishMethod;

    public IStatus publish(int kind, IProgressMonitor monitor) {
        IStatus ret = super.publish(kind, monitor);
        this.setServerPublishState(ret.isOK() ? 1 : 2);
        return ret;
    }

    public void publish(int kind, List<IModule[]> modules, IProgressMonitor monitor, IAdaptable info) throws CoreException {
        this.publishAdaptableInfo = info;
        try {
            try {
                IService service = OpenShiftServerUtils.getService((IServerAttributes)this.getServer());
                if (service != null) {
                    super.publish(kind, modules, monitor, info);
                }
            }
            catch (ResourceForbiddenException rfe) {
                String msg = NLS.bind((String)"Unable to publish to {0} : {1}", (Object)this.getServer().getName(), (Object)rfe.getMessage());
                OpenShiftCoreActivator.pluginLog().logError(msg);
                this.publishAdaptableInfo = null;
            }
        }
        finally {
            this.publishAdaptableInfo = null;
        }
    }

    public IAdaptable getPublishAdaptableInfo() {
        return this.publishAdaptableInfo;
    }

    public boolean canRestartModule(IModule[] module) {
        return module.length == 1;
    }

    public void setupLaunchConfiguration(ILaunchConfigurationWorkingCopy workingCopy, IProgressMonitor monitor) throws CoreException {
    }

    public void stop(boolean force) {
    }

    private OpenShiftServerPublishMethod getPublishMethod() {
        if (this.publishMethod == null) {
            this.publishMethod = new OpenShiftServerPublishMethod();
        }
        return this.publishMethod;
    }

    protected void publishStart(IProgressMonitor monitor) throws CoreException {
        this.getPublishMethod().publishStart(this.getServer(), monitor);
    }

    protected void publishModule(int kind, int deltaKind, IModule[] module, IProgressMonitor monitor) throws CoreException {
        int state = this.getPublishMethod().publishModule(this.getServer(), kind, deltaKind, module, monitor);
        this.setModulePublishState(module, state);
    }

    protected void publishFinish(IProgressMonitor monitor) throws CoreException {
        int serverSyncState = this.getPublishMethod().publishFinish(this.getServer(), monitor);
        this.setServerPublishState(serverSyncState);
    }

    public IStatus canStart(String launchMode) {
        return Status.CANCEL_STATUS;
    }

    public IStatus canRestart(String mode) {
        return Status.CANCEL_STATUS;
    }

    public IStatus canStop() {
        return Status.CANCEL_STATUS;
    }
}

