/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.core.server;

import java.net.URL;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.model.IURLProvider;
import org.jboss.ide.eclipse.as.core.server.internal.DeployableServer;
import org.jboss.ide.eclipse.as.core.server.internal.IExtendedPropertiesProvider;
import org.jboss.ide.eclipse.as.core.server.internal.JBossServer;
import org.jboss.ide.eclipse.as.core.server.internal.extendedproperties.ServerExtendedProperties;
import org.jboss.ide.eclipse.as.wtp.core.util.ServerModelUtilities;
import org.jboss.tools.openshift.common.core.utils.ProjectUtils;
import org.jboss.tools.openshift.core.server.OpenShiftServerExtendedProperties;
import org.jboss.tools.openshift.core.server.OpenShiftServerUtils;

public class OpenShiftServer
extends DeployableServer
implements IURLProvider,
IExtendedPropertiesProvider {
    public static final String OPENSHIFT3_MODE_ID = "openshift3";

    public void setDefaults(IProgressMonitor monitor) {
        super.setDefaults(monitor);
        this.setAttribute("auto-publish-setting", 2);
    }

    public IModule[] getRootModules(IModule module) throws CoreException {
        IStatus status = this.canModifyModules(new IModule[]{module}, null);
        if (status != null && !status.isOK()) {
            throw new CoreException(status);
        }
        IModule[] parents = ServerModelUtilities.getParentModules((IServer)this.getServer(), (IModule)module);
        if (parents.length > 0) {
            return parents;
        }
        return new IModule[]{module};
    }

    public URL getModuleRootURL(IModule module) {
        IProject moduleProject = module.getProject();
        String deployProjectName = OpenShiftServerUtils.getDeployProjectName((IServerAttributes)this.getServer());
        IProject deployProject = ProjectUtils.getProject((String)deployProjectName);
        String contextRoot = this.getContextRoot(moduleProject, deployProject);
        return JBossServer.getModuleRootURL((IModule)module, (String)this.getServer().getHost(), (int)80, (String)contextRoot);
    }

    private String getContextRoot(IProject moduleProject, IProject deployProject) {
        String contextRoot = null;
        if (OpenShiftServerUtils.isIgnoresContextRoot((IServerAttributes)this.getServer()) && moduleProject.equals((Object)deployProject)) {
            contextRoot = "";
        }
        return contextRoot;
    }

    public ServerExtendedProperties getExtendedProperties() {
        return new OpenShiftServerExtendedProperties((IAdaptable)this.getServer());
    }

    public boolean isUseProjectSpecificSchedulingRuleOnPublish() {
        return false;
    }
}

