/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.core.connection;

import com.openshift.restclient.ClientFactory;
import com.openshift.restclient.IClient;
import com.openshift.restclient.ISSLCertificateCallback;
import com.openshift.restclient.OpenShiftException;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.foundation.core.properties.IPropertiesProvider;
import org.jboss.tools.foundation.core.properties.PropertiesHelper;
import org.jboss.tools.openshift.common.core.ICredentialsPrompter;
import org.jboss.tools.openshift.common.core.connection.IConnection;
import org.jboss.tools.openshift.common.core.connection.IConnectionFactory;
import org.jboss.tools.openshift.core.LazyCredentialsPrompter;
import org.jboss.tools.openshift.core.LazySSLCertificateCallback;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.internal.core.OpenShiftCoreActivator;

public class ConnectionFactory
implements IConnectionFactory {
    public static final String OPENSHIFT_USERDOC = "openshift.userdoc.url";

    public String getName() {
        return "OpenShift 3";
    }

    public String getId() {
        return "org.jboss.tools.openshift.core.ConnectionFactory";
    }

    public Connection create(String url) {
        try {
            LazySSLCertificateCallback sslCertCallback = new LazySSLCertificateCallback();
            IClient client = new ClientFactory().create(url, (ISSLCertificateCallback)sslCertCallback);
            return new Connection(client, (ICredentialsPrompter)new LazyCredentialsPrompter(), (ISSLCertificateCallback)sslCertCallback);
        }
        catch (OpenShiftException e) {
            OpenShiftCoreActivator.pluginLog().logInfo(NLS.bind((String)"Could not create OpenShift connection: Malformed url {0}", (Object)url), (Throwable)e);
            return null;
        }
    }

    public String getDefaultHost() {
        return null;
    }

    public boolean hasDefaultHost() {
        return false;
    }

    public <T extends IConnection> boolean canCreate(Class<T> clazz) {
        return Connection.class.isAssignableFrom(clazz);
    }

    public String getSignupUrl(String host) {
        return null;
    }

    public String getUserDocUrl() {
        String userdoc = System.getProperty(OPENSHIFT_USERDOC, null);
        if (userdoc == null) {
            IPropertiesProvider pp = PropertiesHelper.getPropertiesProvider();
            userdoc = pp.getValue(OPENSHIFT_USERDOC, "http://tools.jboss.org/documentation/howto/openshift3_getting_started.html");
        }
        return userdoc;
    }
}

