/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.core.connection;

import com.openshift.internal.restclient.http.NotFoundException;
import com.openshift.restclient.ClientFactory;
import com.openshift.restclient.IClient;
import com.openshift.restclient.IResourceFactory;
import com.openshift.restclient.ISSLCertificateCallback;
import com.openshift.restclient.OpenShiftException;
import com.openshift.restclient.authorization.BasicAuthorizationStrategy;
import com.openshift.restclient.authorization.IAuthorizationContext;
import com.openshift.restclient.authorization.IAuthorizationStrategy;
import com.openshift.restclient.authorization.TokenAuthorizationStrategy;
import com.openshift.restclient.authorization.UnauthorizedException;
import com.openshift.restclient.capability.CapabilityVisitor;
import com.openshift.restclient.capability.resources.IClientCapability;
import com.openshift.restclient.model.IResource;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.List;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.Assert;
import org.jboss.tools.common.databinding.ObservablePojo;
import org.jboss.tools.openshift.common.core.ICredentialsPrompter;
import org.jboss.tools.openshift.common.core.IRefreshable;
import org.jboss.tools.openshift.common.core.connection.ConnectionType;
import org.jboss.tools.openshift.common.core.connection.ConnectionURL;
import org.jboss.tools.openshift.common.core.connection.IConnection;
import org.jboss.tools.openshift.core.OpenShiftCoreUIIntegration;
import org.jboss.tools.openshift.core.preferences.OpenShiftCorePreferences;
import org.jboss.tools.openshift.internal.common.core.UsageStats;
import org.jboss.tools.openshift.internal.common.core.security.OpenShiftSecureStorageKey;
import org.jboss.tools.openshift.internal.common.core.security.SecureStore;
import org.jboss.tools.openshift.internal.common.core.security.SecureStoreException;
import org.jboss.tools.openshift.internal.core.OpenShiftCoreActivator;

public class Connection
extends ObservablePojo
implements IConnection,
IRefreshable {
    private static final String SECURE_STORAGE_BASEKEY = "org.jboss.tools.openshift.core";
    private static final String SECURE_STORAGE_PASSWORD = "password";
    private static final String SECURE_STORAGE_TOKEN = "token";
    private static final String SECURE_STORAGE_AUTHSCHEME = "authtype";
    public static final String PROPERTY_REMEMBER_TOKEN = "rememberToken";
    private IClient client;
    private String username;
    private String password;
    private String token;
    private boolean passwordLoaded;
    private boolean tokenLoaded;
    private boolean rememberPassword;
    private boolean rememberToken;
    private boolean promptCredentialsEnabled = true;
    private ICredentialsPrompter credentialsPrompter;
    private ISSLCertificateCallback sslCertificateCallback;
    private String authScheme;

    public Connection(String url, ICredentialsPrompter credentialsPrompter, ISSLCertificateCallback sslCertCallback) throws MalformedURLException {
        this(new ClientFactory().create(url, sslCertCallback), credentialsPrompter, sslCertCallback);
    }

    public Connection(IClient client, ICredentialsPrompter credentialsPrompter, ISSLCertificateCallback sslCertCallback) {
        this.client = client;
        this.client.setSSLCertificateCallback(sslCertCallback);
        this.credentialsPrompter = credentialsPrompter;
        this.sslCertificateCallback = sslCertCallback;
    }

    public IResourceFactory getResourceFactory() {
        return this.client.getResourceFactory();
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String userName) {
        this.username = userName;
        this.firePropertyChange("username", this.username, this.username);
    }

    public String getPassword() {
        this.loadPassword();
        return this.password;
    }

    private void loadPassword() {
        if (org.jboss.tools.openshift.common.core.utils.StringUtils.isEmpty((String)this.password) && !this.passwordLoaded) {
            this.password = this.load(SECURE_STORAGE_PASSWORD, this.getSecureStore(this.getHost(), this.getUsername()));
            this.passwordLoaded = true;
            this.rememberPassword = this.password != null;
        }
    }

    public void setPassword(String password) {
        this.password = password;
        this.firePropertyChange(SECURE_STORAGE_PASSWORD, this.password, this.password);
        this.passwordLoaded = true;
    }

    public void setRememberPassword(boolean rememberPassword) {
        this.rememberPassword = rememberPassword;
        this.firePropertyChange("rememberPassword", this.rememberPassword, this.rememberPassword);
    }

    public boolean isRememberPassword() {
        return this.rememberPassword;
    }

    public boolean isRememberToken() {
        return this.rememberToken;
    }

    public void setRememberToken(boolean rememberToken) {
        this.rememberToken = rememberToken;
        this.firePropertyChange(PROPERTY_REMEMBER_TOKEN, this.rememberToken, this.rememberToken);
    }

    public void enablePromptCredentials(boolean enable) {
        this.promptCredentialsEnabled = enable;
    }

    public void save() {
        this.saveOrClear(SECURE_STORAGE_PASSWORD, this.password, this.isRememberPassword(), this.getSecureStore(this.getHost(), this.getUsername()));
        this.saveOrClear(SECURE_STORAGE_TOKEN, this.token, this.isRememberToken(), this.getSecureStore(this.getHost(), this.getUsername()));
        ConnectionURL url = ConnectionURL.safeForConnection((IConnection)this);
        if (url != null) {
            OpenShiftCorePreferences.INSTANCE.saveAuthScheme(url.toString(), this.getAuthScheme());
        }
    }

    public String getAuthScheme() {
        return StringUtils.defaultIfBlank((String)this.authScheme, (String)"OAuth");
    }

    private String load(String id, SecureStore store) {
        String value = null;
        if (store != null) {
            try {
                value = store.get(id);
            }
            catch (SecureStoreException e) {
                OpenShiftCoreActivator.pluginLog().logError(e.getMessage(), (Throwable)e);
            }
        }
        return value;
    }

    private void saveOrClear(String id, String value, boolean saveOrClear, SecureStore store) {
        if (store != null) {
            try {
                if (saveOrClear && !org.jboss.tools.openshift.common.core.utils.StringUtils.isEmpty((String)value)) {
                    store.put(id, value);
                } else {
                    store.remove(id);
                }
            }
            catch (SecureStoreException e) {
                OpenShiftCoreActivator.logError("Exception saving connection property", e);
            }
        }
    }

    private SecureStore getSecureStore(String host, String username) {
        return new SecureStore((SecureStore.IStoreKey)new OpenShiftSecureStorageKey(SECURE_STORAGE_BASEKEY, host, username));
    }

    public boolean connect() throws OpenShiftException {
        if (this.authorize()) {
            this.save();
            return true;
        }
        return false;
    }

    private boolean authorize() {
        this.client.setAuthorizationStrategy(this.getAuthorizationStrategy());
        try {
            IAuthorizationContext context = this.client.getContext(this.client.getBaseURL().toString());
            if (!context.isAuthorized() && this.credentialsPrompter != null && this.promptCredentialsEnabled) {
                this.credentialsPrompter.promptAndAuthenticate((IConnection)this, null);
            } else {
                this.setToken(context.getToken());
                TokenAuthorizationStrategy tokenStrategy = new TokenAuthorizationStrategy(this.getToken(), context.getUser().getName());
                this.client.setAuthorizationStrategy((IAuthorizationStrategy)tokenStrategy);
                this.updateCredentials(context);
            }
        }
        catch (UnauthorizedException e) {
            if (!this.promptCredentialsEnabled || this.credentialsPrompter == null) {
                throw e;
            }
            this.credentialsPrompter.promptAndAuthenticate((IConnection)this, (Object)e.getAuthorizationDetails());
        }
        return this.getToken() != null;
    }

    private void updateCredentials(IAuthorizationContext context) {
        if ("OAuth".equalsIgnoreCase(this.getAuthScheme())) {
            this.setUsername(context.getUser().getName());
        }
    }

    private IAuthorizationStrategy getAuthorizationStrategy() {
        String scheme = this.getAuthScheme();
        String token = this.getToken();
        if (StringUtils.isNotEmpty((String)token) || "OAuth".equalsIgnoreCase(scheme)) {
            return new TokenAuthorizationStrategy(token);
        }
        if ("Basic".equalsIgnoreCase(scheme)) {
            return new BasicAuthorizationStrategy(this.getUsername(), this.getPassword(), this.getToken());
        }
        throw new OpenShiftException("Authscheme '%s' is not supported.", new Object[]{scheme});
    }

    public void setAuthScheme(String scheme) {
        this.authScheme = scheme;
        this.firePropertyChange(SECURE_STORAGE_AUTHSCHEME, this.authScheme, this.authScheme);
    }

    public String getHost() {
        return this.client.getBaseURL().toString();
    }

    public boolean isDefaultHost() {
        return false;
    }

    public String getScheme() {
        return String.valueOf(this.client.getBaseURL().getProtocol()) + "://";
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.client == null ? 0 : this.client.getBaseURL().hashCode());
        result = 31 * result + (this.username == null ? 0 : this.username.hashCode());
        return result;
    }

    public IConnection clone() {
        Connection connection = new Connection(this.client, this.credentialsPrompter, this.sslCertificateCallback);
        connection.setUsername(this.username);
        connection.setPassword(this.password);
        connection.setRememberPassword(this.rememberPassword);
        connection.setToken(this.token);
        connection.setAuthScheme(this.authScheme);
        connection.promptCredentialsEnabled = this.promptCredentialsEnabled;
        return connection;
    }

    public void update(IConnection connection) {
        Assert.isLegal((boolean)(connection instanceof Connection));
        Connection otherConnection = (Connection)connection;
        this.client = otherConnection.client;
        this.credentialsPrompter = otherConnection.credentialsPrompter;
        this.sslCertificateCallback = otherConnection.sslCertificateCallback;
        this.username = otherConnection.username;
        this.password = otherConnection.password;
        this.rememberPassword = otherConnection.rememberPassword;
        this.token = otherConnection.token;
        this.rememberToken = otherConnection.rememberToken;
    }

    public void refresh() {
        this.connect();
    }

    public ConnectionType getType() {
        return ConnectionType.Kubernetes;
    }

    public String toString() {
        return this.client.getBaseURL().toString();
    }

    public <T extends IResource> T createResource(T resource) {
        try {
            if (this.client.getAuthorizationStrategy() == null) {
                this.client.setAuthorizationStrategy(this.getAuthorizationStrategy());
            }
            return (T)this.client.create(resource);
        }
        catch (UnauthorizedException e) {
            return this.retryCreate("Unauthorized.  Trying to reauthenticate", (OpenShiftException)((Object)e), resource);
        }
    }

    public <T extends IResource> List<T> getResources(String kind) {
        return this.getResources(kind, "");
    }

    public <T extends IResource> List<T> getResources(String kind, String namespace) {
        try {
            if (this.client.getAuthorizationStrategy() == null) {
                this.client.setAuthorizationStrategy(this.getAuthorizationStrategy());
            }
            this.client.setSSLCertificateCallback(OpenShiftCoreUIIntegration.getInstance().getSSLCertificateCallback());
            return this.client.list(kind, namespace);
        }
        catch (UnauthorizedException e) {
            return this.retryList("Unauthorized.  Trying to reauthenticate", (OpenShiftException)((Object)e), kind);
        }
    }

    public <T extends IResource> T getResource(IResource resource) {
        try {
            if (this.client.getAuthorizationStrategy() == null) {
                this.client.setAuthorizationStrategy(this.getAuthorizationStrategy());
            }
            return (T)this.client.get(resource.getKind(), resource.getName(), resource.getNamespace());
        }
        catch (UnauthorizedException e) {
            return this.retryGet("Unauthorized.  Trying to reauthenticate", (OpenShiftException)((Object)e), resource);
        }
    }

    private <T extends IResource> T retryGet(String message, OpenShiftException e, IResource resource) {
        OpenShiftCoreActivator.pluginLog().logInfo(message);
        this.setToken(null);
        if (this.connect()) {
            return (T)this.client.get(resource.getKind(), resource.getName(), resource.getNamespace());
        }
        throw e;
    }

    private <T extends IResource> T retryCreate(String message, OpenShiftException e, T resource) {
        OpenShiftCoreActivator.pluginLog().logInfo(message);
        this.setToken(null);
        if (this.connect()) {
            return (T)this.client.create(resource);
        }
        throw e;
    }

    private <T extends IResource> List<T> retryList(String message, OpenShiftException e, String kind) {
        OpenShiftCoreActivator.pluginLog().logInfo(message);
        this.setToken(null);
        if (this.connect()) {
            return this.client.list(kind);
        }
        throw e;
    }

    public void deleteResource(IResource resource) {
        this.client.delete(resource);
    }

    public boolean canConnect() throws IOException {
        try {
            this.client.getOpenShiftAPIVersion();
            return true;
        }
        catch (NotFoundException notFoundException) {
            return false;
        }
    }

    public String getToken() {
        this.loadToken();
        return this.token;
    }

    private synchronized void loadToken() {
        if (org.jboss.tools.openshift.common.core.utils.StringUtils.isEmpty((String)this.token) && !this.tokenLoaded) {
            this.tokenLoaded = true;
            this.setToken(this.load(SECURE_STORAGE_TOKEN, this.getSecureStore(this.getHost(), this.getUsername())));
            this.rememberToken = StringUtils.isNotBlank((String)this.token);
        }
    }

    public void setToken(String token) {
        this.token = token;
        this.firePropertyChange(SECURE_STORAGE_TOKEN, token, this.token);
        this.tokenLoaded = true;
    }

    public void notifyUsage() {
        UsageStats.getInstance().newV3Connection(this.getHost());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        Connection other = (Connection)((Object)obj);
        if (this.username == null ? other.username != null : !this.username.equals(other.username)) {
            return false;
        }
        return !(this.client == null ? other.client != null : other.client == null || !this.client.getBaseURL().toString().equals(other.client.getBaseURL().toString()));
    }

    public boolean ownsResource(IResource resource) {
        if (resource == null) {
            return false;
        }
        IClient client = (IClient)resource.accept((CapabilityVisitor)new CapabilityVisitor<IClientCapability, IClient>(){

            public IClient visit(IClientCapability capability) {
                return capability.getClient();
            }
        }, null);
        return ObjectUtils.equals((Object)this.client, (Object)client);
    }
}

