/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.coordinates.osgi;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.net.InternetDomainName;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipFile;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.recommenders.coordinates.AbstractProjectCoordinateAdvisor;
import org.eclipse.recommenders.coordinates.Coordinates;
import org.eclipse.recommenders.coordinates.DependencyInfo;
import org.eclipse.recommenders.coordinates.DependencyType;
import org.eclipse.recommenders.coordinates.ProjectCoordinate;
import org.eclipse.recommenders.coordinates.osgi.OsgiVersionParser;
import org.eclipse.recommenders.utils.Versions;
import org.eclipse.recommenders.utils.Zips;

public class OsgiManifestAdvisor
extends AbstractProjectCoordinateAdvisor {
    public static final Attributes.Name BUNDLE_NAME = new Attributes.Name("Bundle-SymbolicName");
    public static final Attributes.Name BUNDLE_VERSION = new Attributes.Name("Bundle-Version");
    private Zips.IFileToJarFileConverter jarFileConverter;

    public OsgiManifestAdvisor() {
        this.jarFileConverter = new Zips.DefaultJarFileConverter();
    }

    @VisibleForTesting
    public OsgiManifestAdvisor(Zips.IFileToJarFileConverter fileToJarFileConverter) {
        this.jarFileConverter = fileToJarFileConverter;
    }

    @Override
    protected Optional<ProjectCoordinate> doSuggest(DependencyInfo dependencyInfo) {
        Optional<Manifest> optionalManifest = Optional.absent();
        if (dependencyInfo.getType() == DependencyType.JAR) {
            optionalManifest = this.extractManifestFromJar(dependencyInfo);
        } else if (dependencyInfo.getType() == DependencyType.PROJECT) {
            optionalManifest = this.extractManifestFromProject(dependencyInfo);
        }
        if (optionalManifest.isPresent()) {
            return this.extractProjectCoordinateFromManifest((Manifest)optionalManifest.get());
        }
        return Optional.absent();
    }

    private Optional<Manifest> extractManifestFromProject(DependencyInfo dependencyInfo) {
        File projectFolder = dependencyInfo.getFile();
        File metaInfFolder = new File(projectFolder, "META-INF");
        File manifestFile = new File(metaInfFolder, "MANIFEST.MF");
        if (manifestFile.exists()) {
            Optional optional;
            FileInputStream in = null;
            try {
                in = new FileInputStream(manifestFile);
                Manifest manifest = new Manifest(in);
                optional = Optional.of((Object)manifest);
            }
            catch (IOException iOException) {
                Optional optional2;
                try {
                    optional2 = Optional.absent();
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(in);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)in);
                return optional2;
            }
            IOUtils.closeQuietly((InputStream)in);
            return optional;
        }
        return Optional.absent();
    }

    private Optional<Manifest> extractManifestFromJar(DependencyInfo dependencyInfo) {
        Optional optionalJarFile = this.jarFileConverter.createJarFile(dependencyInfo.getFile());
        if (!optionalJarFile.isPresent()) {
            return Optional.absent();
        }
        JarFile jarFile = (JarFile)optionalJarFile.get();
        try {
            Manifest manifest = jarFile.getManifest();
            Optional optional = Optional.fromNullable((Object)manifest);
            return optional;
        }
        catch (IOException iOException) {
            Optional optional = Optional.absent();
            return optional;
        }
        finally {
            Zips.closeQuietly((ZipFile)jarFile);
        }
    }

    private Optional<ProjectCoordinate> extractProjectCoordinateFromManifest(Manifest manifest) {
        Attributes attributes = manifest.getMainAttributes();
        String bundleName = attributes.getValue(BUNDLE_NAME);
        String bundleVersion = attributes.getValue(BUNDLE_VERSION);
        if (bundleName == null || bundleVersion == null) {
            return Optional.absent();
        }
        int indexOf = bundleName.indexOf(59);
        String artifactId = bundleName.substring(0, indexOf == -1 ? bundleName.length() : indexOf);
        Optional<String> groupId = OsgiManifestAdvisor.guessGroupId(artifactId);
        Optional<String> version = OsgiVersionParser.parse(bundleVersion);
        if (groupId.isPresent() && version.isPresent()) {
            return Coordinates.tryNewProjectCoordinate((String)groupId.get(), artifactId, Versions.canonicalizeVersion((String)((String)version.get())));
        }
        return Optional.absent();
    }

    @Override
    public boolean isApplicable(DependencyType type) {
        return DependencyType.JAR == type || DependencyType.PROJECT == type;
    }

    private static Optional<String> guessGroupId(String reverseDomainName) {
        Object[] segments = StringUtils.split((String)reverseDomainName, (String)".");
        OsgiManifestAdvisor.removeSlashes((String[])segments);
        Object[] reverse = OsgiManifestAdvisor.copyAndReverse((String[])segments);
        try {
            InternetDomainName name = InternetDomainName.from((String)StringUtils.join((Object[])reverse, (String)"."));
            if (!name.isUnderPublicSuffix()) {
                return Optional.of((Object)segments[0]);
            }
            InternetDomainName topPrivateDomain = name.topPrivateDomain();
            int size = topPrivateDomain.parts().size();
            int end = Math.min(segments.length, size + 1);
            return Optional.of((Object)StringUtils.join((Object[])ArrayUtils.subarray((Object[])segments, (int)0, (int)end), (String)"."));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return Optional.absent();
        }
    }

    private static String[] copyAndReverse(String[] segments) {
        Object[] reverse = (String[])segments.clone();
        ArrayUtils.reverse((Object[])reverse);
        return reverse;
    }

    private static void removeSlashes(String[] segments) {
        int i = segments.length;
        while (i-- > 0) {
            segments[i] = StringUtils.replace((String)segments[i], (String)"/", (String)"");
        }
    }
}

