/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.jdt.debug.tools.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstall2;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.common.jdt.debug.Messages;
import org.jboss.tools.common.jdt.debug.RemoteDebugActivator;
import org.jboss.tools.common.jdt.debug.tools.ToolsCoreException;
import org.jboss.tools.common.jdt.debug.tools.internal.IToolsConstants;

public class Tools
implements IEclipsePreferences.IPreferenceChangeListener,
IToolsConstants {
    static final String LOCALHOST = "localhost";
    private ClassLoader toolsLoader;
    private static Tools tools;
    private boolean isReady;
    private File toolsJarFile;

    public static synchronized Tools getInstance() {
        if (tools == null) {
            tools = new Tools();
        }
        return tools;
    }

    private Tools() {
        this.reset();
        if (!this.isReady) {
            IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.jboss.tools.common.jdt.debug");
            prefs.addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        }
    }

    public File getToolsJarFile() {
        return this.toolsJarFile;
    }

    public void reset() {
        this.toolsLoader = null;
        this.getToolsLoader();
        this.isReady = this.validateClassPathAndLibraryPath();
    }

    private ClassLoader getToolsLoader() {
        if (this.toolsLoader == null) {
            this.toolsLoader = Thread.currentThread().getContextClassLoader();
            File toolsJar = this.getToolsJar();
            if (toolsJar == null) {
                return this.toolsLoader;
            }
            try {
                toolsJar = toolsJar.getCanonicalFile();
            }
            catch (IOException iOException) {
                return this.toolsLoader;
            }
            if (toolsJar.exists()) {
                URL toolsUrl;
                this.toolsJarFile = toolsJar;
                try {
                    toolsUrl = toolsJar.toURI().toURL();
                }
                catch (MalformedURLException malformedURLException) {
                    return this.toolsLoader;
                }
                this.toolsLoader = new URLClassLoader(new URL[]{toolsUrl}, this.toolsLoader);
            }
        }
        return this.toolsLoader;
    }

    private File getToolsJar() {
        String jdkRootDirectory = this.findHomeDirectoryToAddToClasspath();
        File file = new File(String.valueOf(jdkRootDirectory) + TOOLS_JAR);
        return file;
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        if ("org.jboss.tools.common.jdt.debug.jdkVMInstall".equals(event.getKey()) && !this.isReady) {
            this.toolsLoader = null;
            this.getToolsLoader();
            this.isReady = this.validateClassPathAndLibraryPath();
        }
    }

    public boolean isReady() {
        return this.isReady;
    }

    public String validateJdkRootDirectory(String jdkRootDirectory) {
        if (jdkRootDirectory == null || jdkRootDirectory.trim().isEmpty()) {
            return Messages.NoJdkDirectoryFoundMsg;
        }
        File directory = new File(jdkRootDirectory);
        if (!directory.exists() || !directory.isDirectory()) {
            return Messages.directoryNotExistMsg;
        }
        File toolsJarFile = new File(String.valueOf(jdkRootDirectory) + TOOLS_JAR);
        if (!toolsJarFile.exists()) {
            return Messages.notJdkRootDirectoryMsg;
        }
        String libraryPath = Tools.getJreLibraryPath(jdkRootDirectory);
        if (libraryPath == null) {
            return Messages.notJdkRootDirectoryMsg;
        }
        return null;
    }

    private IVMInstall[] getAllVMInstalls() {
        ArrayList<IVMInstall> all = new ArrayList<IVMInstall>();
        IVMInstallType[] iVMInstallTypeArray = JavaRuntime.getVMInstallTypes();
        int n = iVMInstallTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IVMInstallType type = iVMInstallTypeArray[n2];
            IVMInstall[] iVMInstallArray = type.getVMInstalls();
            int n3 = iVMInstallArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IVMInstall install = iVMInstallArray[n4];
                all.add(install);
                ++n4;
            }
            ++n2;
        }
        return all.toArray(new IVMInstall[all.size()]);
    }

    private int compareJavaVersions(String version0, String version1) {
        int[] arg1majorMinor;
        int[] arg0majorMinor = this.getMajorMinor(version0);
        if (arg0majorMinor[0] < (arg1majorMinor = this.getMajorMinor(version1))[0]) {
            return -1;
        }
        if (arg0majorMinor[0] > arg1majorMinor[0]) {
            return 1;
        }
        if (arg0majorMinor[1] < arg1majorMinor[1]) {
            return -1;
        }
        if (arg0majorMinor[1] > arg1majorMinor[1]) {
            return 1;
        }
        return 0;
    }

    public IVMInstall[] getAllCompatibleInstalls() {
        String currentVersion = System.getProperty("java.version");
        ArrayList<IVMInstall2> compat = new ArrayList<IVMInstall2>();
        IVMInstall[] all = this.getAllVMInstalls();
        int i = 0;
        while (i < all.length) {
            String vers;
            if (all[i] instanceof IVMInstall2 && this.compareJavaVersions(currentVersion, vers = ((IVMInstall2)all[i]).getJavaVersion()) >= 0) {
                compat.add((IVMInstall2)all[i]);
            }
            ++i;
        }
        Comparator<IVMInstall2> comparator = new Comparator<IVMInstall2>(){

            @Override
            public int compare(IVMInstall2 arg0, IVMInstall2 arg1) {
                String arg0vers = arg0.getJavaVersion();
                String arg1vers = arg1.getJavaVersion();
                return Tools.this.compareJavaVersions(arg0vers, arg1vers);
            }
        };
        Collections.sort(compat, comparator);
        Collections.reverse(compat);
        return compat.toArray(new IVMInstall[compat.size()]);
    }

    private int[] getMajorMinor(String version) {
        Matcher m = Pattern.compile("^(\\d+)\\.(\\d+)\\..*").matcher(version);
        if (!m.matches()) {
            throw new IllegalArgumentException("Malformed version string");
        }
        return new int[]{Integer.parseInt(m.group(1)), Integer.parseInt(m.group(2))};
    }

    private IVMInstall findFirstValidVMInstall() {
        IVMInstall[] all = this.getAllCompatibleInstalls();
        int i = 0;
        while (i < all.length) {
            String jdkRootDirectory = all[i].getInstallLocation().getPath();
            if (this.validateJdkRootDirectory(jdkRootDirectory) == null) {
                return all[i];
            }
            ++i;
        }
        RemoteDebugActivator.pluginLog().logMessage(2, Messages.jdkRootDirectoryNotFoundMsg, (Throwable)new Exception());
        return null;
    }

    public String findJdkRootFromJavaHome() {
        String javaHome = System.getProperty("java.home");
        for (File directory : Tools.getPossibleJdkRootDirectory(javaHome)) {
            String path = directory.getPath();
            if (this.validateJdkRootDirectory(path) != null) continue;
            return path;
        }
        return null;
    }

    private static List<File> getPossibleJdkRootDirectory(String javaHome) {
        ArrayList<File> dirs = new ArrayList<File>();
        if (Platform.getOS().equals("macosx")) {
            int index = javaHome.indexOf("JavaVirtualMachines");
            if (index == -1) {
                return dirs;
            }
            String javaVirtualMachinesPath = javaHome.substring(0, index + "JavaVirtualMachines".length());
            File dir = new File(javaVirtualMachinesPath);
            Tools.collectDirs(dirs, dir, 3);
            return dirs;
        }
        File parentDir = new File(String.valueOf(javaHome) + File.separator + "..");
        dirs.add(parentDir);
        if (parentDir.exists()) {
            File[] fileArray = parentDir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    dirs.add(file);
                }
                ++n2;
            }
        }
        return dirs;
    }

    private static void collectDirs(List<File> dirs, File dir, int depth) {
        if (depth > 0) {
            File[] fileArray = dir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    dirs.add(file);
                    Tools.collectDirs(dirs, file, depth - 1);
                }
                ++n2;
            }
        }
    }

    private boolean validateClassPathAndLibraryPath() {
        try {
            this.invokeGetMonitoredHost(LOCALHOST);
        }
        catch (ToolsCoreException toolsCoreException) {
            return false;
        }
        return true;
    }

    private IVMInstall findHomeDirFromPreferences() {
        IVMInstall found;
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.jboss.tools.common.jdt.debug");
        String vm = prefs.get("org.jboss.tools.common.jdt.debug.jdkVMInstall", null);
        if (vm != null && (found = Tools.findVMInstall(vm)) != null) {
            return found;
        }
        return null;
    }

    private static IVMInstall findVMInstall(String id) {
        if (id != null) {
            IVMInstallType[] types = JavaRuntime.getVMInstallTypes();
            IVMInstall ret = null;
            int i = 0;
            while (i < types.length) {
                ret = types[i].findVMInstall(id);
                if (ret != null) {
                    return ret;
                }
                ++i;
            }
        }
        return null;
    }

    private static IVMInstall findVMByInstallLocation(String home) {
        if (home != null) {
            IVMInstallType[] types = JavaRuntime.getVMInstallTypes();
            int i = 0;
            while (i < types.length) {
                IVMInstall[] installs = types[i].getVMInstalls();
                int j = 0;
                while (j < installs.length) {
                    if (home.equals(installs[j].getInstallLocation())) {
                        return installs[j];
                    }
                    ++j;
                }
                ++i;
            }
        }
        return null;
    }

    private String findHomeDirectoryToAddToClasspath() {
        IVMInstall vmi;
        String jdkRootDirectory = this.findJdkRootFromJavaHome();
        if ((jdkRootDirectory == null || jdkRootDirectory.trim().isEmpty()) && (vmi = this.findSecondaryVMInstall()) != null) {
            jdkRootDirectory = vmi.getInstallLocation().getAbsolutePath();
        }
        return jdkRootDirectory;
    }

    public IVMInstall findSecondaryVMInstall() {
        IVMInstall vmi = this.findHomeDirFromPreferences();
        if (vmi == null) {
            vmi = this.findFirstValidVMInstall();
        }
        return vmi;
    }

    public IVMInstall findActiveVM() {
        String javaHome = System.getProperty("java.home");
        return Tools.findVMByInstallLocation(javaHome);
    }

    public boolean hasActiveVMInstall() {
        return this.findActiveVM() != null;
    }

    private static String getJreLibraryPath(String jdkRootDirectory) {
        String[] stringArray = LIBRARY_PATHS;
        int n = LIBRARY_PATHS.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            File attachLibraryFile = new File(String.valueOf(jdkRootDirectory) + path + File.separator + System.mapLibraryName("attach"));
            if (attachLibraryFile.exists()) {
                return String.valueOf(jdkRootDirectory) + path;
            }
            ++n2;
        }
        return null;
    }

    public Properties invokeGetAgentProperties(Object virtualMachine) throws ToolsCoreException {
        ClassLoader currentLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getToolsLoader());
            Class<?> clazz = this.getToolsLoader().loadClass("com.sun.tools.attach.VirtualMachine");
            Method method = clazz.getDeclaredMethod("getAgentProperties", new Class[0]);
            Properties properties = (Properties)method.invoke(virtualMachine, new Object[0]);
            return properties;
        }
        catch (Throwable t) {
            throw new ToolsCoreException(4, t.getMessage(), t);
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentLoader);
        }
    }

    public synchronized Object invokeGetMonitoredHost(String hostname) throws ToolsCoreException {
        ClassLoader currentLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getToolsLoader());
            Class<?> clazz = this.getToolsLoader().loadClass("sun.jvmstat.monitor.MonitoredHost");
            Method method = clazz.getDeclaredMethod("getMonitoredHost", String.class);
            Object object = method.invoke(null, hostname);
            return object;
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new ToolsCoreException(4, t.getMessage(), t);
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentLoader);
        }
    }

    public Set<Integer> invokeActiveVms(String hostname) throws ToolsCoreException {
        return this.invokeActiveVms(this.invokeGetMonitoredHost(hostname));
    }

    public Set<Integer> invokeActiveVms(Object monitoredHost) throws ToolsCoreException {
        ClassLoader currentLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getToolsLoader());
            Class<?> clazz = this.getToolsLoader().loadClass("sun.jvmstat.monitor.MonitoredHost");
            Method method = clazz.getDeclaredMethod("activeVms", new Class[0]);
            Set set = (Set)method.invoke(monitoredHost, new Object[0]);
            return set;
        }
        catch (Throwable t) {
            throw new ToolsCoreException(4, t.getMessage(), t);
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentLoader);
        }
    }

    public Object invokeVmIdentifier(String vmId) throws ToolsCoreException {
        ClassLoader currentLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getToolsLoader());
            Constructor<?> clazz = this.getToolsLoader().loadClass("sun.jvmstat.monitor.VmIdentifier").getConstructor(String.class);
            Object obj = clazz.newInstance(vmId);
            return obj;
        }
        catch (Throwable t) {
            throw new ToolsCoreException(4, t.getMessage(), t);
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentLoader);
        }
    }

    public synchronized Object invokeGetMonitoredVm(Object monitoredHost, Object vmIdentifier) throws ToolsCoreException {
        ClassLoader currentLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getToolsLoader());
            Class<?> clazz = this.getToolsLoader().loadClass("sun.jvmstat.monitor.MonitoredHost");
            Class<?> clazz2 = this.getToolsLoader().loadClass("sun.jvmstat.monitor.VmIdentifier");
            Method method = clazz.getDeclaredMethod("getMonitoredVm", clazz2);
            Object object = method.invoke(monitoredHost, vmIdentifier);
            return object;
        }
        catch (Throwable t) {
            throw new ToolsCoreException(4, t.getMessage(), t);
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentLoader);
        }
    }

    public Object getMonitoredVm(String hostname, int pid) throws ToolsCoreException {
        Object monitoredVm = this.invokeGetMonitoredVm(this.invokeGetMonitoredHost(hostname), this.invokeVmIdentifier(String.format("//%d?mode=r", pid)));
        return monitoredVm;
    }

    public Object invokeFindByName(Object monitoredVm, String name) throws ToolsCoreException {
        ClassLoader currentLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getToolsLoader());
            Class<?> clazz = this.getToolsLoader().loadClass("sun.jvmstat.monitor.MonitoredVm");
            Method method = clazz.getDeclaredMethod("findByName", String.class);
            Object object = method.invoke(monitoredVm, name);
            return object;
        }
        catch (Throwable t) {
            throw new ToolsCoreException(4, t.getMessage(), t);
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentLoader);
        }
    }

    public Object invokeGetValue(Object monitor) throws ToolsCoreException {
        ClassLoader currentLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getToolsLoader());
            Class<?> clazz = this.getToolsLoader().loadClass("sun.jvmstat.monitor.Monitor");
            Method method = clazz.getDeclaredMethod("getValue", new Class[0]);
            Object object = method.invoke(monitor, new Object[0]);
            return object;
        }
        catch (Throwable t) {
            throw new ToolsCoreException(4, t.getMessage(), t);
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentLoader);
        }
    }

    public Object invokeAttach(int pid) throws ToolsCoreException {
        ClassLoader currentLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getToolsLoader());
            Class<?> clazz = this.getToolsLoader().loadClass("com.sun.tools.attach.VirtualMachine");
            Method method = clazz.getDeclaredMethod("attach", String.class);
            Object object = method.invoke(null, String.valueOf(pid));
            return object;
        }
        catch (Throwable t) {
            throw new ToolsCoreException(4, t.getCause().getMessage(), t);
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentLoader);
        }
    }

    public void invokeDetach(Object vm) throws ToolsCoreException {
        ClassLoader currentLoader = Thread.currentThread().getContextClassLoader();
        try {
            try {
                Thread.currentThread().setContextClassLoader(this.getToolsLoader());
                Class<?> clazz = this.getToolsLoader().loadClass("com.sun.tools.attach.VirtualMachine");
                Method method = clazz.getDeclaredMethod("detach", new Class[0]);
                method.invoke(vm, new Object[0]);
            }
            catch (Throwable t) {
                throw new ToolsCoreException(4, t.getMessage(), t);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentLoader);
        }
    }

    public Object invokeGetSystemProperties(Object vm) throws ToolsCoreException {
        ClassLoader currentLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getToolsLoader());
            Class<?> clazz = this.getToolsLoader().loadClass("com.sun.tools.attach.VirtualMachine");
            Method method = clazz.getDeclaredMethod("getSystemProperties", new Class[0]);
            Object object = method.invoke(vm, new Object[0]);
            return object;
        }
        catch (Throwable t) {
            throw new ToolsCoreException(4, t.getMessage(), t);
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentLoader);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void invokeLoadAgent(Object virtualMachine, String path, String options) throws ToolsCoreException {
        block6: {
            currentLoader = Thread.currentThread().getContextClassLoader();
            try {
                block7: {
                    try {
                        Thread.currentThread().setContextClassLoader(this.getToolsLoader());
                        clazz = this.getToolsLoader().loadClass("com.sun.tools.attach.VirtualMachine");
                        method = clazz.getDeclaredMethod("loadAgent", new Class[]{String.class, String.class});
                        method.invoke(virtualMachine, new Object[]{path, options});
                        break block6;
                    }
                    catch (Throwable t) {
                        message = t.getMessage();
                        if (message != null) break block7;
                        cause = t.getCause();
                        ** while (cause != null)
                    }
lbl-1000:
                    // 1 sources

                    {
                        message = cause.getMessage();
                        if (message != null) break;
                        cause = cause.getCause();
                        continue;
                    }
                }
                throw new ToolsCoreException(4, message, t);
            }
            finally {
                Thread.currentThread().setContextClassLoader(currentLoader);
            }
        }
    }

    public InputStream invokeHeapHisto(Object virtualMachine, boolean isLive) throws ToolsCoreException {
        ClassLoader currentLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getToolsLoader());
            Class<?> clazz = this.getToolsLoader().loadClass("sun.tools.attach.HotSpotVirtualMachine");
            Method method = clazz.getDeclaredMethod("heapHisto", Object[].class);
            Object[] arg = new Object[]{isLive ? "-live" : "-all"};
            InputStream inputStream = (InputStream)method.invoke(virtualMachine, new Object[]{arg});
            return inputStream;
        }
        catch (Throwable t) {
            throw new ToolsCoreException(4, t.getMessage(), t);
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentLoader);
        }
    }

    public String getJvmArgs(String hostname, int vmPid) throws ToolsCoreException {
        ClassLoader currentLoader = Thread.currentThread().getContextClassLoader();
        try {
            Object vm = this.getMonitoredVm(hostname, vmPid);
            Class<?> vmUtil = this.toolsLoader.loadClass("sun.jvmstat.monitor.MonitoredVmUtil");
            Class<?> monitoredVm = this.toolsLoader.loadClass("sun.jvmstat.monitor.MonitoredVm");
            Method jvmArgs = vmUtil.getDeclaredMethod("jvmArgs", monitoredVm);
            Object jvmArgsObj = jvmArgs.invoke(null, vm);
            String string = (String)jvmArgsObj;
            return string;
        }
        catch (Throwable t) {
            throw new ToolsCoreException(4, t.getMessage(), t);
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentLoader);
        }
    }

    public String getMainClass(String hostname, int vmPid) throws ToolsCoreException {
        ClassLoader currentLoader = Thread.currentThread().getContextClassLoader();
        try {
            Object vm = this.getMonitoredVm(hostname, vmPid);
            Class<?> vmUtil = this.toolsLoader.loadClass("sun.jvmstat.monitor.MonitoredVmUtil");
            Class<?> monitoredVm = this.toolsLoader.loadClass("sun.jvmstat.monitor.MonitoredVm");
            Method mainClass = vmUtil.getDeclaredMethod("mainClass", monitoredVm, Boolean.TYPE);
            Object mainClassObj = mainClass.invoke(null, vm, true);
            String string = (String)mainClassObj;
            return string;
        }
        catch (Throwable t) {
            throw new ToolsCoreException(4, t.getMessage(), t);
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentLoader);
        }
    }

    public String getMainArgs(String hostname, int vmPid) throws ToolsCoreException {
        ClassLoader currentLoader = Thread.currentThread().getContextClassLoader();
        try {
            Object vm = this.getMonitoredVm(hostname, vmPid);
            Class<?> vmUtil = this.toolsLoader.loadClass("sun.jvmstat.monitor.MonitoredVmUtil");
            Class<?> monitoredVm = this.toolsLoader.loadClass("sun.jvmstat.monitor.MonitoredVm");
            Method mainArgs = vmUtil.getDeclaredMethod("mainArgs", monitoredVm);
            Object mainArgsObj = mainArgs.invoke(null, vm);
            String string = (String)mainArgsObj;
            return string;
        }
        catch (Throwable t) {
            throw new ToolsCoreException(4, t.getMessage(), t);
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentLoader);
        }
    }

    public String getJavaCommand(String host, int pid) throws ToolsCoreException {
        return this.getJavaCommand(this.getMonitoredVm(host, pid), pid);
    }

    public String getJavaCommand(Object monitoredVm, int pid) throws ToolsCoreException {
        String javaCommand = null;
        try {
            Object monitor = this.invokeFindByName(monitoredVm, "sun.rt.javaCommand");
            if (monitor != null) {
                javaCommand = tools.invokeGetValue(monitor).toString();
                return javaCommand == null ? "" : javaCommand;
            }
        }
        catch (ToolsCoreException e) {
            String message = NLS.bind((String)Messages.getMainClassNameFailed, (Object)pid);
            throw new ToolsCoreException(4, message, (Throwable)((Object)e));
        }
        return "";
    }
}

