/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.asciidoc.core.util;

import org.eclipse.mylyn.internal.wikitext.asciidoc.core.util.LookAheadReader;
import org.eclipse.mylyn.internal.wikitext.asciidoc.core.util.ReadAheadBlock;
import org.eclipse.mylyn.wikitext.core.parser.MarkupParser;
import org.eclipse.mylyn.wikitext.core.parser.markup.Block;
import org.eclipse.mylyn.wikitext.core.parser.markup.ContentState;

public class ReadAheadDispatcher
extends Block {
    private final LookAheadReader lookAheadReader;
    private Block[] blocks;
    private Block dispatchedBlock;

    public ReadAheadDispatcher(Block ... blocks) {
        this.blocks = blocks;
        this.lookAheadReader = new LookAheadReader();
    }

    public boolean canStart(String line, int lineOffset) {
        this.dispatchedBlock = null;
        return true;
    }

    protected int processLineContent(String line, int offset) {
        if (this.dispatchedBlock == null) {
            this.lookAheadReader.setContentState(this.getState());
            Block[] blockArray = this.blocks;
            int n = this.blocks.length;
            int n2 = 0;
            while (n2 < n) {
                Block block = blockArray[n2];
                if (block instanceof ReadAheadBlock) {
                    ReadAheadBlock raBlock = (ReadAheadBlock)ReadAheadBlock.class.cast(block);
                    if (raBlock.canStart(line, offset, this.lookAheadReader)) {
                        this.dispatchedBlock = block;
                        break;
                    }
                } else if (block.canStart(line, offset)) {
                    this.dispatchedBlock = block;
                    break;
                }
                ++n2;
            }
        }
        int result = this.dispatchedBlock.processLine(line, offset);
        if (this.dispatchedBlock.isClosed()) {
            this.setClosed(true);
        }
        return result;
    }

    public void setClosed(boolean closed) {
        this.dispatchedBlock.setClosed(closed);
        super.setClosed(closed);
    }

    public void setState(ContentState state) {
        Block[] blockArray = this.blocks;
        int n = this.blocks.length;
        int n2 = 0;
        while (n2 < n) {
            Block block = blockArray[n2];
            block.setState(state);
            ++n2;
        }
        super.setState(state);
    }

    public void setParser(MarkupParser parser) {
        Block[] blockArray = this.blocks;
        int n = this.blocks.length;
        int n2 = 0;
        while (n2 < n) {
            Block block = blockArray[n2];
            block.setParser(parser);
            ++n2;
        }
        super.setParser(parser);
    }

    public Block clone() {
        ReadAheadDispatcher clone = (ReadAheadDispatcher)super.clone();
        Block[] clonedBlocks = new Block[this.blocks.length];
        int i = 0;
        Block[] blockArray = this.blocks;
        int n = this.blocks.length;
        int n2 = 0;
        while (n2 < n) {
            Block block = blockArray[n2];
            clonedBlocks[i++] = block.clone();
            ++n2;
        }
        clone.blocks = clonedBlocks;
        return clone;
    }
}

