/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.wizard.snapshot;

import java.io.File;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.MultiValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationUpdater;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.jboss.tools.common.ui.databinding.InvertingBooleanConverter;
import org.jboss.tools.common.ui.databinding.ValueBindingBuilder;
import org.jboss.tools.openshift.common.core.utils.FileUtils;
import org.jboss.tools.openshift.common.core.utils.StringUtils;
import org.jboss.tools.openshift.express.internal.ui.wizard.snapshot.SaveSnapshotWizardModel;
import org.jboss.tools.openshift.express.internal.ui.wizard.snapshot.SaveSnapshotWizardPageModel;
import org.jboss.tools.openshift.internal.common.ui.SelectProjectDialog;
import org.jboss.tools.openshift.internal.common.ui.databinding.RequiredControlDecorationUpdater;
import org.jboss.tools.openshift.internal.common.ui.wizard.AbstractOpenShiftWizardPage;

public class SaveSnapshotWizardPage
extends AbstractOpenShiftWizardPage {
    private SaveSnapshotWizardPageModel pageModel;

    public SaveSnapshotWizardPage(SaveSnapshotWizardModel wizardModel, IWizard wizard) {
        this("Save Snapshot Cartridges", NLS.bind((String)"Please choose the snapshot type and file for the snapshot of application {0}", (Object)StringUtils.null2emptyString((String)wizardModel.getApplication().getName())), wizardModel, wizard);
    }

    protected SaveSnapshotWizardPage(String title, String description, SaveSnapshotWizardModel wizardModel, IWizard wizard) {
        super(title, description, title, wizard);
        this.pageModel = new SaveSnapshotWizardPageModel(wizardModel);
    }

    protected void doCreateControls(Composite parent, DataBindingContext dbc) {
        GridLayoutFactory.fillDefaults().numColumns(5).margins(10, 10).applyTo(parent);
        Label snapshotTypeLabel = new Label(parent, 0);
        snapshotTypeLabel.setText("Snapshot Type:");
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)snapshotTypeLabel);
        Button fullSnapshotButton = new Button(parent, 16);
        fullSnapshotButton.setText("Full");
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)fullSnapshotButton);
        ((ValueBindingBuilder.ModelDefinition)((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.selection().observe((Widget)fullSnapshotButton)).converting((IConverter)new InvertingBooleanConverter())).to(BeanProperties.value((String)"deploymentSnapshot").observe((Object)this.pageModel)).converting((IConverter)new InvertingBooleanConverter())).in(dbc);
        Button deploymentSnapshotButton = new Button(parent, 16);
        deploymentSnapshotButton.setText("Deployment");
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)deploymentSnapshotButton);
        ValueBindingBuilder.bind((IObservableValue)WidgetProperties.selection().observe((Widget)deploymentSnapshotButton)).to(BeanProperties.value((String)"deploymentSnapshot").observe((Object)this.pageModel)).in(dbc);
        GridDataFactory.fillDefaults().align(4, 4).applyTo((Control)new Composite(parent, 0));
        GridDataFactory.fillDefaults().align(4, 4).applyTo((Control)new Composite(parent, 0));
        Label filepathLabel = new Label(parent, 0);
        filepathLabel.setText("Destination:");
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)filepathLabel);
        Text filepathText = new Text(parent, 2048);
        filepathText.setEditable(false);
        GridDataFactory.fillDefaults().span(2, 1).align(4, 0x1000000).hint(200, -1).grab(true, false).applyTo((Control)filepathText);
        ISWTObservableValue filenameObservable = WidgetProperties.text((int)24).observe((Widget)filepathText);
        ValueBindingBuilder.bind((IObservableValue)filenameObservable).to(BeanProperties.value((String)"filepath").observe((Object)this.pageModel)).in(dbc);
        Button workspaceButton = new Button(parent, 8);
        workspaceButton.setText("Workspace...");
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).hint(100, -1).applyTo((Control)workspaceButton);
        workspaceButton.addSelectionListener((SelectionListener)this.onWorkspace());
        Button browseButton = new Button(parent, 8);
        browseButton.setText("Browse...");
        GridDataFactory.fillDefaults().align(4, 0x1000000).hint(100, -1).applyTo((Control)browseButton);
        browseButton.addSelectionListener((SelectionListener)this.onBrowse());
        FilenameValidator filenameValidator = new FilenameValidator((IObservableValue)filenameObservable);
        dbc.addValidationStatusProvider((ValidationStatusProvider)filenameValidator);
        ControlDecorationSupport.create((ValidationStatusProvider)filenameValidator, (int)16512, null, (ControlDecorationUpdater)new RequiredControlDecorationUpdater());
        GridDataFactory.fillDefaults().align(4, 4).span(3, 1).grab(true, true).applyTo((Control)new Composite(parent, 0));
    }

    private SelectionAdapter onBrowse() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(SaveSnapshotWizardPage.this.getShell(), 0);
                dialog.setText("Choose the destination for your snapshot");
                dialog.setFilterPath(FileUtils.getParent((String)SaveSnapshotWizardPage.this.pageModel.getFilepath()));
                String destination = dialog.open();
                if (!StringUtils.isEmpty((String)destination)) {
                    SaveSnapshotWizardPage.this.pageModel.setDestination(destination);
                }
            }
        };
    }

    private SelectionAdapter onWorkspace() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IProject project;
                SelectProjectDialog dialog = new SelectProjectDialog(SaveSnapshotWizardPage.this.getShell());
                if (dialog.open() == 0 && (project = dialog.getSelectedProject()) != null) {
                    SaveSnapshotWizardPage.this.pageModel.setProject(project);
                }
            }
        };
    }

    static class FilenameValidator
    extends MultiValidator {
        private IObservableValue filenameObservable;

        public FilenameValidator(IObservableValue filenameObservable) {
            this.filenameObservable = filenameObservable;
        }

        protected IStatus validate() {
            String filename = (String)this.filenameObservable.getValue();
            if (StringUtils.isEmpty((String)filename)) {
                return ValidationStatus.cancel((String)"Please provide a file that we can save your snapshot to.");
            }
            File snapshotFile = new File(filename);
            if (snapshotFile.exists()) {
                return ValidationStatus.warning((String)NLS.bind((String)"File {0} already exists. Saving to it may overwrite it.", (Object)filename));
            }
            if (snapshotFile.isDirectory() && !snapshotFile.canWrite()) {
                return ValidationStatus.error((String)NLS.bind((String)"Cannot write to file {0}. Please check your permissions.", (Object)filename));
            }
            return ValidationStatus.ok();
        }

        public IObservableList getTargets() {
            WritableList targets = new WritableList();
            targets.add((Object)this.filenameObservable);
            return targets;
        }
    }
}

