/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.wizard.snapshot;

import com.jcraft.jsch.Session;
import com.openshift.client.IApplication;
import com.openshift.internal.client.ApplicationSSHSession;
import com.openshift.internal.client.utils.StreamUtils;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.jboss.tools.common.databinding.ObservablePojo;
import org.jboss.tools.openshift.common.core.utils.FileUtils;
import org.jboss.tools.openshift.express.internal.core.preferences.ExpressCorePreferences;
import org.jboss.tools.openshift.express.internal.ui.utils.SSHSessionRepository;

public class SaveSnapshotWizardModel
extends ObservablePojo {
    private String filepath;
    private boolean deploymentSnapshot;
    private IApplication application;
    private IProject project;

    public SaveSnapshotWizardModel(IApplication application) {
        this.application = application;
        this.filepath = FileUtils.getAvailableFilepath((String)this.getSnapshotFromPreferences(application, this.deploymentSnapshot));
    }

    public IApplication getApplication() {
        return this.application;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public String setFilepath(String filename) {
        this.filepath = filename;
        return this.filepath;
    }

    public String getFilepath() {
        return this.filepath;
    }

    public boolean setDeploymentSnapshot(boolean deploymentSnapshot) {
        this.deploymentSnapshot = deploymentSnapshot;
        return this.deploymentSnapshot;
    }

    public boolean isDeploymentSnapshot() {
        return this.deploymentSnapshot;
    }

    public void saveSnapshot(IProgressMonitor monitor) throws IOException, CoreException {
        if (monitor.isCanceled()) {
            return;
        }
        Session session = SSHSessionRepository.getInstance().getSession(this.application);
        if (this.isDeploymentSnapshot()) {
            InputStream saveResponse = new ApplicationSSHSession(this.application, session).saveDeploymentSnapshot();
            StreamUtils.writeTo((InputStream)saveResponse, (OutputStream)new FileOutputStream(this.getFilepath()));
        } else {
            InputStream saveResponse = new ApplicationSSHSession(this.application, session).saveFullSnapshot();
            StreamUtils.writeTo((InputStream)saveResponse, (OutputStream)new FileOutputStream(this.getFilepath()));
        }
        this.storeSnapshotToPreferences(this.filepath, this.deploymentSnapshot);
        if (this.project != null) {
            this.project.refreshLocal(2, monitor);
        }
    }

    private void storeSnapshotToPreferences(String filepath, boolean deploymentSnapshot) {
        if (deploymentSnapshot) {
            ExpressCorePreferences.INSTANCE.saveDeploymentSnapshot(this.getApplication(), filepath);
        } else {
            ExpressCorePreferences.INSTANCE.saveFullSnapshot(this.getApplication(), filepath);
        }
    }

    private String getSnapshotFromPreferences(IApplication application, boolean deploymentSnapshot) {
        if (deploymentSnapshot) {
            return ExpressCorePreferences.INSTANCE.getDeploymentSnapshot(application);
        }
        return ExpressCorePreferences.INSTANCE.getFullSnapshot(application);
    }
}

