/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.wizard.snapshot;

import com.openshift.client.IApplication;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.common.ui.WizardUtils;
import org.jboss.tools.openshift.common.ui.wizard.AbstractOpenShiftWizard;
import org.jboss.tools.openshift.express.internal.ui.ExpressUIActivator;
import org.jboss.tools.openshift.express.internal.ui.wizard.snapshot.SaveSnapshotWizardModel;
import org.jboss.tools.openshift.express.internal.ui.wizard.snapshot.SaveSnapshotWizardPage;
import org.jboss.tools.openshift.internal.common.core.job.AbstractDelegatingMonitorJob;

public class SaveSnapshotWizard
extends AbstractOpenShiftWizard<SaveSnapshotWizardModel> {
    public SaveSnapshotWizard(IApplication application) {
        super("Save Snapshot", (Object)new SaveSnapshotWizardModel(application));
    }

    public boolean performFinish() {
        final String applicationName = ((SaveSnapshotWizardModel)((Object)this.getModel())).getApplication().getName();
        try {
            IStatus status = WizardUtils.runInWizard((Job)new AbstractDelegatingMonitorJob(NLS.bind((String)"Saving snapshot for application {0}...", (Object)applicationName)){

                protected IStatus doRun(IProgressMonitor monitor) {
                    try {
                        ((SaveSnapshotWizardModel)((Object)SaveSnapshotWizard.this.getModel())).saveSnapshot(monitor);
                        return Status.OK_STATUS;
                    }
                    catch (IOException e) {
                        return ExpressUIActivator.createErrorStatus(NLS.bind((String)"Could not save snapshot for application {0}", (Object)applicationName), e);
                    }
                    catch (CoreException e) {
                        return e.getStatus();
                    }
                }
            }, (IWizardContainer)this.getContainer());
            return status.isOK();
        }
        catch (InvocationTargetException e) {
            IStatus status = ExpressUIActivator.createErrorStatus(e.getMessage(), e);
            new ErrorDialog(this.getShell(), "Error", NLS.bind((String)"Could not save snapshot for application {0}", (Object)applicationName), status, 4).open();
            return false;
        }
        catch (InterruptedException e) {
            IStatus status = ExpressUIActivator.createErrorStatus(e.getMessage(), e);
            new ErrorDialog(this.getShell(), "Error", NLS.bind((String)"Could not save snapshot for application {0}", (Object)applicationName), status, 4).open();
            return false;
        }
    }

    public void addPages() {
        this.addPage((IWizardPage)new SaveSnapshotWizardPage((SaveSnapshotWizardModel)((Object)this.getModel()), (IWizard)this));
    }
}

