/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.wizard.embed;

import com.openshift.client.cartridge.ICartridge;
import java.util.Set;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.jboss.tools.common.ui.WizardUtils;
import org.jboss.tools.common.ui.databinding.ValueBindingBuilder;
import org.jboss.tools.foundation.core.jobs.DelegatingProgressMonitor;
import org.jboss.tools.openshift.common.core.utils.StringUtils;
import org.jboss.tools.openshift.express.internal.core.util.ExpressResourceLabelUtils;
import org.jboss.tools.openshift.express.internal.ui.ExpressUIActivator;
import org.jboss.tools.openshift.express.internal.ui.viewer.EmbeddableCartridgeViewerSorter;
import org.jboss.tools.openshift.express.internal.ui.viewer.EqualityComparer;
import org.jboss.tools.openshift.express.internal.ui.wizard.embed.CartridgeDetailViews;
import org.jboss.tools.openshift.express.internal.ui.wizard.embed.EmbeddedCartridgesWizardModel;
import org.jboss.tools.openshift.express.internal.ui.wizard.embed.EmbeddedCartridgesWizardPageModel;
import org.jboss.tools.openshift.express.internal.ui.wizard.embed.FullfillRequirementsCheckStrategy;
import org.jboss.tools.openshift.express.internal.ui.wizard.embed.Messages;
import org.jboss.tools.openshift.internal.common.core.job.AbstractDelegatingMonitorJob;
import org.jboss.tools.openshift.internal.common.ui.utils.TableViewerBuilder;
import org.jboss.tools.openshift.internal.common.ui.wizard.AbstractOpenShiftWizardPage;

public class EmbeddedCartridgesWizardPage
extends AbstractOpenShiftWizardPage {
    private EmbeddedCartridgesWizardPageModel pageModel;

    public EmbeddedCartridgesWizardPage(EmbeddedCartridgesWizardModel wizardModel, IWizard wizard) {
        this("Embed Cartridges", NLS.bind((String)"Please select the cartridges to embed into your application {0}", (Object)StringUtils.null2emptyString((String)wizardModel.getApplicationName())), wizardModel, wizard);
    }

    protected EmbeddedCartridgesWizardPage(String title, String description, EmbeddedCartridgesWizardModel wizardModel, IWizard wizard) {
        super(title, description, "EmbedCartridgePage", wizard);
        this.pageModel = new EmbeddedCartridgesWizardPageModel(wizardModel);
    }

    public void setCheckedEmbeddableCartridges(Set<ICartridge> embeddableCartridges) {
        this.pageModel.setCheckedCartridges(embeddableCartridges);
    }

    protected void doCreateControls(Composite parent, DataBindingContext dbc) {
        GridLayoutFactory.fillDefaults().numColumns(2).margins(10, 10).applyTo(parent);
        Composite tableContainer = new Composite(parent, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).hint(500, 400).applyTo((Control)tableContainer);
        CheckboxTableViewer viewer = this.createCartridgesTableViewer(tableContainer);
        viewer.setInput((Object)BeanProperties.list((String)"embeddableCartridges").observe((Object)this.pageModel));
        dbc.bindSet((IObservableSet)ViewerProperties.checkedElements(ICartridge.class).observe((Viewer)viewer), BeanProperties.set((String)"checkedCartridges").observe((Object)this.pageModel));
        viewer.addCheckStateListener(this.onCartridgeChecked(this.pageModel, (IWizardPage)this));
        IObservableValue selectedCartridgeObservable = BeanProperties.value((String)"selectedCartridge").observe((Object)this.pageModel);
        ValueBindingBuilder.bind((IObservableValue)ViewerProperties.singlePostSelection().observe((Viewer)viewer)).to(selectedCartridgeObservable).in(dbc);
        this.createButtons(parent, dbc);
        Group cartridgeDetailsGroup = new Group(parent, 0);
        cartridgeDetailsGroup.setText(" Selected Cartridge: ");
        GridDataFactory.fillDefaults().span(2, 1).align(4, 4).grab(true, false).hint(-1, 140).applyTo((Control)cartridgeDetailsGroup);
        new CartridgeDetailViews(selectedCartridgeObservable, BeanProperties.value((String)"canAddRemoveCartridges").observe((Object)this.pageModel), (Composite)cartridgeDetailsGroup, dbc).createControls();
    }

    protected void createButtons(Composite parent, DataBindingContext dbc) {
        Button deselectAllButton = new Button(parent, 8);
        deselectAllButton.setText("&Deselect All");
        GridDataFactory.fillDefaults().hint(110, -1).align(4, 128).applyTo((Control)deselectAllButton);
        deselectAllButton.addSelectionListener(this.onDeselectAll());
    }

    protected ICheckStateListener onCartridgeChecked(EmbeddedCartridgesWizardPageModel pageModel, IWizardPage wizardPage) {
        return new FullfillRequirementsCheckStrategy(pageModel, wizardPage);
    }

    protected CheckboxTableViewer createCartridgesTableViewer(Composite tableContainer) {
        Table table = new Table(tableContainer, 68384);
        table.setLinesVisible(true);
        CheckboxTableViewer tableViewer = new CheckboxTableViewer(table);
        new TableViewerBuilder((TableViewer)tableViewer, tableContainer).sorter((ViewerSorter)new EmbeddableCartridgeViewerSorter()).comparer((IElementComparer)new EqualityComparer()).contentProvider((IStructuredContentProvider)new ObservableListContentProvider()).column("Embeddable Cartridge").labelProvider((TableViewerBuilder.IColumnLabelProvider)new TableViewerBuilder.IColumnLabelProvider<ICartridge>(){

            public String getValue(ICartridge cartridge) {
                return ExpressResourceLabelUtils.toString((ICartridge)cartridge);
            }
        }).weight(1).buildColumn().buildViewer();
        return tableViewer;
    }

    protected void onPageActivated(DataBindingContext dbc) {
        try {
            AbstractDelegatingMonitorJob job = new AbstractDelegatingMonitorJob("Loading embeddable cartridges..."){

                protected IStatus doRun(IProgressMonitor monitor) {
                    try {
                        EmbeddedCartridgesWizardPage.this.pageModel.loadOpenShiftResources();
                        return Status.OK_STATUS;
                    }
                    catch (Exception e) {
                        return ExpressUIActivator.createErrorStatus("Could not load embeddable cartridges", e);
                    }
                }
            };
            WizardUtils.runInWizard((Job)job, (DelegatingProgressMonitor)job.getDelegatingProgressMonitor(), (IWizardContainer)this.getContainer(), (DataBindingContext)this.getDataBindingContext());
        }
        catch (Exception exception) {}
    }

    private SelectionListener onDeselectAll() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (MessageDialog.openQuestion((Shell)EmbeddedCartridgesWizardPage.this.getShell(), (String)Messages.DESELECT_ALL_CARTRIDGES_TITLE, (String)Messages.DESELECT_ALL_CARTRIDGES_DESCRIPTION)) {
                    EmbeddedCartridgesWizardPage.this.pageModel.uncheckAll();
                }
            }
        };
    }

    public Set<ICartridge> getCheckedCartridges() {
        return this.pageModel.getCheckedCartridges();
    }
}

