/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.wizard.domain;

import com.openshift.client.IDomain;
import com.openshift.client.OpenShiftEndpointException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.common.ui.WizardUtils;
import org.jboss.tools.foundation.core.jobs.DelegatingProgressMonitor;
import org.jboss.tools.openshift.common.ui.wizard.AbstractOpenShiftWizard;
import org.jboss.tools.openshift.express.internal.ui.ExpressUIActivator;
import org.jboss.tools.openshift.express.internal.ui.utils.Logger;
import org.jboss.tools.openshift.express.internal.ui.wizard.domain.DomainWizardModel;
import org.jboss.tools.openshift.express.internal.ui.wizard.domain.EditDomainWizardPage;
import org.jboss.tools.openshift.internal.common.core.job.AbstractDelegatingMonitorJob;

public class EditDomainWizard
extends AbstractOpenShiftWizard<DomainWizardModel> {
    public EditDomainWizard(IDomain domain) {
        super("Edit domain", (Object)new DomainWizardModel(domain));
    }

    public boolean performFinish() {
        AbstractDelegatingMonitorJob job = new AbstractDelegatingMonitorJob("Renaming domain..."){

            protected IStatus doRun(IProgressMonitor monitor) {
                try {
                    ((DomainWizardModel)((Object)EditDomainWizard.this.getModel())).renameDomain();
                    return Status.OK_STATUS;
                }
                catch (OpenShiftEndpointException e) {
                    return ExpressUIActivator.createErrorStatus(NLS.bind((String)"Could not rename domain \"{0}\": {1}", (Object)((DomainWizardModel)((Object)EditDomainWizard.this.getModel())).getDomainId(), (Object)e.getRestResponseMessages()), e);
                }
                catch (Exception e) {
                    return ExpressUIActivator.createErrorStatus(NLS.bind((String)"Could not rename domain {0}", (Object)((DomainWizardModel)((Object)EditDomainWizard.this.getModel())).getDomainId()), e);
                }
            }
        };
        try {
            IStatus status = WizardUtils.runInWizard((Job)job, (DelegatingProgressMonitor)job.getDelegatingProgressMonitor(), (IWizardContainer)this.getContainer());
            return status.isOK();
        }
        catch (Exception ex) {
            Logger.error("Could not rename domain", ex);
            return false;
        }
    }

    public void addPages() {
        this.addPage((IWizardPage)new EditDomainWizardPage((DomainWizardModel)((Object)this.getModel()), (IWizard)this));
    }
}

