/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.wizard.application.details;

import com.openshift.client.IApplication;
import com.openshift.client.OpenShiftException;
import com.openshift.client.cartridge.ICartridge;
import com.openshift.client.cartridge.IEmbeddedCartridge;
import java.net.SocketTimeoutException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.openshift.egit.core.EGitUtils;
import org.jboss.tools.openshift.express.internal.core.util.ExpressResourceLabelUtils;
import org.jboss.tools.openshift.express.internal.ui.propertytable.AbstractPropertyTableContentProvider;
import org.jboss.tools.openshift.express.internal.ui.propertytable.ContainerElement;
import org.jboss.tools.openshift.express.internal.ui.propertytable.StringElement;
import org.jboss.tools.openshift.express.internal.ui.utils.Logger;

public class ApplicationDetailsContentProvider
extends AbstractPropertyTableContentProvider {
    @Override
    public Object[] getElements(Object inputElement) {
        ArrayList<ContainerElement> elements = new ArrayList<ContainerElement>();
        if (inputElement instanceof IApplication) {
            IApplication application = (IApplication)inputElement;
            try {
                elements.add(new StringElement("Name", new ApplicationPropertyGetter(application){

                    @Override
                    protected String doGet(IApplication application) {
                        return application.getName();
                    }
                }.safeGet()));
                elements.add(new StringElement("Public URL", new ApplicationPropertyGetter(application){

                    @Override
                    protected String doGet(IApplication application) {
                        return application.getApplicationUrl().toString();
                    }
                }.safeGet(), true));
                elements.add(new StringElement("Type", new ApplicationPropertyGetter(application){

                    @Override
                    protected String doGet(IApplication application) {
                        return ExpressResourceLabelUtils.toString((ICartridge)application.getCartridge());
                    }
                }.safeGet()));
                elements.add(new StringElement("Created on", new ApplicationPropertyGetter(application){

                    @Override
                    protected String doGet(IApplication application) {
                        return new SimpleDateFormat("yyyy/MM/dd 'at' HH:mm:ss").format(application.getCreationTime());
                    }
                }.safeGet()));
                elements.add(new StringElement("UUID", new ApplicationPropertyGetter(application){

                    @Override
                    protected String doGet(IApplication application) {
                        return application.getUUID();
                    }
                }.safeGet()));
                elements.add(new StringElement("Git URL", new ApplicationPropertyGetter(application){

                    @Override
                    protected String doGet(IApplication application) {
                        return application.getGitUrl();
                    }
                }.safeGet()));
                elements.add(new StringElement("SSH ExpressConnection", new ApplicationPropertyGetter(application){

                    @Override
                    protected String doGet(IApplication application) {
                        String gitUrl = application.getGitUrl();
                        return EGitUtils.getGitUsername((String)gitUrl) + '@' + EGitUtils.getGitHost((String)gitUrl);
                    }
                }.safeGet()));
                elements.add(new StringElement("Scalable", new ApplicationPropertyGetter(application){

                    @Override
                    protected String doGet(IApplication application) {
                        return application.getApplicationScale().getValue();
                    }
                }.safeGet()));
                elements.add(this.createCartridges(new ContainerElement("Cartridges"), application));
            }
            catch (Exception e) {
                Logger.error(NLS.bind((String)"Could not display details for OpenShift application {0}", (Object)application.getName()), e);
            }
        }
        return elements.toArray();
    }

    private ContainerElement createCartridges(ContainerElement cartridgesContainer, IApplication application) throws OpenShiftException, SocketTimeoutException {
        for (IEmbeddedCartridge cartridge : application.getEmbeddedCartridges()) {
            cartridgesContainer.add(new StringElement(cartridge.getName(), new ApplicationPropertyGetter(application){

                @Override
                protected String doGet(IApplication application) {
                    return application.getApplicationScale().getValue();
                }
            }.safeGet(), true));
        }
        return cartridgesContainer;
    }

    private static abstract class ApplicationPropertyGetter {
        private IApplication application;

        ApplicationPropertyGetter(IApplication application) {
            this.application = application;
        }

        protected abstract String doGet(IApplication var1);

        public String safeGet() {
            try {
                return this.doGet(this.application);
            }
            catch (Exception e) {
                Logger.error(NLS.bind((String)"Could not display details for OpenShift application {0}", (Object)this.application.getName()), e);
                return "<could not get property>";
            }
        }
    }
}

