/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.wizard.application;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.MultiValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.dialogs.PageChangingEvent;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.statushandlers.StatusManager;
import org.jboss.tools.common.ui.WizardUtils;
import org.jboss.tools.common.ui.databinding.InvertingBooleanConverter;
import org.jboss.tools.common.ui.databinding.ValueBindingBuilder;
import org.jboss.tools.common.ui.ssh.SshPrivateKeysPreferences;
import org.jboss.tools.openshift.common.core.utils.FileUtils;
import org.jboss.tools.openshift.common.core.utils.StringUtils;
import org.jboss.tools.openshift.common.ui.wizard.OkButtonWizardDialog;
import org.jboss.tools.openshift.egit.core.EGitUtils;
import org.jboss.tools.openshift.express.internal.ui.ExpressUIActivator;
import org.jboss.tools.openshift.express.internal.ui.job.LoadKeysJob;
import org.jboss.tools.openshift.express.internal.ui.utils.LinkSelectionAdapter;
import org.jboss.tools.openshift.express.internal.ui.wizard.application.ExpressApplicationWizard;
import org.jboss.tools.openshift.express.internal.ui.wizard.application.GitCloningSettingsWizardPageModel;
import org.jboss.tools.openshift.express.internal.ui.wizard.application.IOpenShiftApplicationWizardModel;
import org.jboss.tools.openshift.express.internal.ui.wizard.ssh.ManageSSHKeysWizard;
import org.jboss.tools.openshift.internal.common.core.job.JobChainBuilder;
import org.jboss.tools.openshift.internal.common.ui.utils.UIUtils;
import org.jboss.tools.openshift.internal.common.ui.wizard.AbstractOpenShiftWizardPage;

public class GitCloningSettingsWizardPage
extends AbstractOpenShiftWizardPage {
    private GitCloningSettingsWizardPageModel pageModel;
    private IOpenShiftApplicationWizardModel wizardModel;
    private Button useDefaultRemoteNameButton;
    private Button useDefaultRepoPathButton;
    private Text remoteNameText;
    private Label remoteNameLabel;
    private RepoPathValidationStatusProvider repoPathValidator;
    private RemoteNameValidationStatusProvider remoteNameValidator;
    private Link sshLink;

    public GitCloningSettingsWizardPage(ExpressApplicationWizard wizard, IOpenShiftApplicationWizardModel wizardModel) {
        super("Import an existing OpenShift application", "Configure the cloning settings by specifying the clone destination if you create a new project, and the git remote name if you're using an existing project.", "Cloning settings", (IWizard)wizard);
        this.pageModel = new GitCloningSettingsWizardPageModel(wizardModel);
        this.wizardModel = wizardModel;
    }

    protected void doCreateControls(Composite parent, DataBindingContext dbc) {
        GridLayoutFactory.fillDefaults().applyTo(parent);
        Composite cloneGroup = this.createCloneGroup(parent, dbc);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)cloneGroup);
        Composite filler = new Composite(parent, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)filler);
    }

    private Composite createCloneGroup(Composite parent, DataBindingContext dbc) {
        Group cloneGroup = new Group(parent, 0);
        cloneGroup.setText("Cloning settings");
        cloneGroup.setLayoutData((Object)new GridData(4, 128, true, false));
        GridLayoutFactory.fillDefaults().numColumns(3).equalWidth(false).margins(10, 10).applyTo((Composite)cloneGroup);
        Composite composite = new Composite((Composite)cloneGroup, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)composite);
        GridLayoutFactory.fillDefaults().numColumns(3).margins(15, 15).applyTo(composite);
        this.useDefaultRepoPathButton = new Button(composite, 32);
        this.useDefaultRepoPathButton.setText("Use default clone destination");
        this.useDefaultRepoPathButton.setToolTipText("Uncheck if you want to use a custom location to clone to");
        GridDataFactory.fillDefaults().align(16384, 0x1000000).span(3, 1).applyTo((Control)this.useDefaultRepoPathButton);
        Label labelForRepoPath = new Label(composite, 0);
        labelForRepoPath.setText("Git Clone Destination:");
        GridDataFactory.fillDefaults().align(16384, 0x1000000).grab(false, false).indent(10, 0).applyTo((Control)labelForRepoPath);
        Text repoPathText = new Text(composite, 2048);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).align(4, 0x1000000).grab(true, false).applyTo((Control)repoPathText);
        ISWTObservableValue repoPathObservable = WidgetProperties.text((int)24).observe((Widget)repoPathText);
        IObservableValue repoPathModelObservable = BeanProperties.value((String)"repositoryPath").observe((Object)this.pageModel);
        ValueBindingBuilder.bind((IObservableValue)repoPathObservable).to(repoPathModelObservable).in(dbc);
        Button browseRepoPathButton = new Button(composite, 8);
        browseRepoPathButton.setText("Browse...");
        GridDataFactory.fillDefaults().align(16384, 0x1000000).hint(100, -1).applyTo((Control)browseRepoPathButton);
        browseRepoPathButton.addSelectionListener(this.onRepoPath());
        ISWTObservableValue isDefaultRepoObservable = WidgetProperties.selection().observe((Widget)this.useDefaultRepoPathButton);
        IObservableValue useDefaultRepoModelObservable = BeanProperties.value((String)"useDefaultRepoPath").observe((Object)this.pageModel);
        ValueBindingBuilder.bind((IObservableValue)isDefaultRepoObservable).to(useDefaultRepoModelObservable).in(dbc);
        ((ValueBindingBuilder.ModelDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.enabled().observe((Widget)repoPathText)).notUpdating(useDefaultRepoModelObservable).converting((IConverter)new InvertingBooleanConverter())).in(dbc);
        ((ValueBindingBuilder.ModelDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.enabled().observe((Widget)browseRepoPathButton)).notUpdating(useDefaultRepoModelObservable).converting((IConverter)new InvertingBooleanConverter())).in(dbc);
        UIUtils.focusOnSelection((Button)this.useDefaultRepoPathButton, (Text)repoPathText);
        this.repoPathValidator = new RepoPathValidationStatusProvider((IObservableValue)repoPathObservable, BeanProperties.value((String)"applicationName").observe((Object)this.pageModel), BeanProperties.value((String)"newProject").observe((Object)this.pageModel));
        dbc.addValidationStatusProvider((ValidationStatusProvider)this.repoPathValidator);
        ControlDecorationSupport.create((ValidationStatusProvider)this.repoPathValidator, (int)16512);
        this.useDefaultRemoteNameButton = new Button(composite, 32);
        this.useDefaultRemoteNameButton.setText("Use default remote name");
        GridDataFactory.fillDefaults().align(16384, 0x1000000).span(3, 1).applyTo((Control)this.useDefaultRemoteNameButton);
        this.remoteNameLabel = new Label(composite, 0);
        this.remoteNameLabel.setText("Remote name:");
        GridDataFactory.fillDefaults().align(16384, 0x1000000).grab(false, false).indent(10, 0).applyTo((Control)this.remoteNameLabel);
        this.remoteNameText = new Text(composite, 2048);
        GridDataFactory.fillDefaults().span(1, 1).align(16384, 0x1000000).align(4, 0x1000000).grab(true, false).applyTo((Control)this.remoteNameText);
        ISWTObservableValue remoteNameTextObservable = WidgetProperties.text((int)24).observe((Widget)this.remoteNameText);
        IObservableValue remoteNameModelObservable = BeanProperties.value((String)"remoteName").observe((Object)this.pageModel);
        ValueBindingBuilder.bind((IObservableValue)remoteNameTextObservable).to(remoteNameModelObservable).in(dbc);
        IObservableValue useDefaultRemoteNameModelObservable = BeanProperties.value((String)"useDefaultRemoteName").observe((Object)this.pageModel);
        ISWTObservableValue useDefaultRemoteNameObservable = WidgetProperties.selection().observe((Widget)this.useDefaultRemoteNameButton);
        ValueBindingBuilder.bind((IObservableValue)useDefaultRemoteNameObservable).to(useDefaultRemoteNameModelObservable).in(dbc);
        ((ValueBindingBuilder.ModelDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.enabled().observe((Widget)this.remoteNameText)).notUpdating(useDefaultRemoteNameModelObservable).converting((IConverter)new InvertingBooleanConverter())).in(dbc);
        ((ValueBindingBuilder.ModelDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.enabled().observe((Widget)this.remoteNameLabel)).notUpdating(useDefaultRemoteNameModelObservable).converting((IConverter)new InvertingBooleanConverter())).in(dbc);
        this.useDefaultRemoteNameButton.addSelectionListener((SelectionListener)this.onDefaultRemoteNameUnchecked());
        IObservableValue projectNameModelObservable = BeanProperties.value((String)"projectName").observe((Object)this.wizardModel);
        this.remoteNameValidator = new RemoteNameValidationStatusProvider((IObservableValue)remoteNameTextObservable, projectNameModelObservable);
        dbc.addValidationStatusProvider((ValidationStatusProvider)this.remoteNameValidator);
        ControlDecorationSupport.create((ValidationStatusProvider)this.remoteNameValidator, (int)16512);
        this.sshLink = new Link(parent, 0);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).indent(10, 0).applyTo((Control)this.sshLink);
        this.sshLink.addSelectionListener((SelectionListener)this.onSshPrefs("SSH2 Preferences"));
        this.sshLink.addSelectionListener((SelectionListener)this.onManageSSHKeys("SSH Keys wizard", dbc));
        Label dummyLabel = new Label(parent, 0);
        dummyLabel.setVisible(false);
        GridDataFactory.fillDefaults().exclude(true).applyTo((Control)dummyLabel);
        ((ValueBindingBuilder.ModelDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.text().observe((Widget)dummyLabel)).notUpdating(BeanProperties.value((String)"hasRemoteKeys").observe((Object)this.pageModel)).validatingAfterGet(new IValidator(){

            public IStatus validate(Object value) {
                if (!(value instanceof Boolean)) {
                    return ValidationStatus.ok();
                }
                Boolean hasRemoteKeys = (Boolean)value;
                if (hasRemoteKeys.booleanValue()) {
                    return ValidationStatus.ok();
                }
                return ValidationStatus.error((String)"No public keys found in your account. Please use the SSH keys wizard.");
            }
        })).in(dbc);
        this.refreshHasRemoteKeys(dbc);
        return cloneGroup;
    }

    private SelectionAdapter onDefaultRemoteNameUnchecked() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GitCloningSettingsWizardPage.this.remoteNameText.setFocus();
            }
        };
    }

    private SelectionListener onRepoPath() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(GitCloningSettingsWizardPage.this.getShell());
                dialog.setText("Git clone location");
                dialog.setMessage("Choose the location for git clone...");
                dialog.setFilterPath(GitCloningSettingsWizardPage.this.pageModel.getRepositoryPath());
                String repositoryPath = dialog.open();
                if (repositoryPath != null) {
                    GitCloningSettingsWizardPage.this.pageModel.setRepositoryPath(repositoryPath);
                }
            }
        };
    }

    private SelectionAdapter onSshPrefs(String text) {
        return new LinkSelectionAdapter(text){

            @Override
            public void doWidgetSelected(SelectionEvent e) {
                SshPrivateKeysPreferences.openPreferencesPage((Shell)GitCloningSettingsWizardPage.this.getShell());
            }
        };
    }

    private SelectionAdapter onManageSSHKeys(String text, final DataBindingContext dbc) {
        return new LinkSelectionAdapter(text){

            @Override
            public void doWidgetSelected(SelectionEvent e) {
                OkButtonWizardDialog manageSSHKeysWizard = new OkButtonWizardDialog(GitCloningSettingsWizardPage.this.getShell(), (IWizard)new ManageSSHKeysWizard(GitCloningSettingsWizardPage.this.pageModel.getConnection()));
                if (manageSSHKeysWizard.open() == 0) {
                    GitCloningSettingsWizardPage.this.refreshHasRemoteKeys(dbc);
                }
            }
        };
    }

    protected void onPageActivated(DataBindingContext dbc) {
        this.enableWidgets(this.pageModel.isNewProject());
        this.repoPathValidator.forceRevalidate();
        this.remoteNameValidator.forceRevalidate();
        this.setSSHLinkText();
        if (this.pageModel.isConnected()) {
            this.refreshHasRemoteKeys(dbc);
        }
    }

    private void setSSHLinkText() {
        if (this.pageModel.isConnected()) {
            this.sshLink.setText("Make sure that you have SSH keys added to your OpenShift account " + this.pageModel.getConnection().getUsername() + " via <a>SSH Keys wizard</a> and that the private keys are listed in <a>SSH2 Preferences</a>");
        } else {
            this.sshLink.setText("Make sure that you have SSH keys added to your OpenShift account via <a>SSH Keys wizard</a> and that the private keys are listed in <a>SSH2 Preferences</a>");
        }
        this.sshLink.getParent().layout(true, true);
    }

    private void refreshHasRemoteKeys(DataBindingContext dbc) {
        try {
            if (!this.pageModel.isConnected()) {
                return;
            }
            final LoadKeysJob loadKeysJob = new LoadKeysJob(this.pageModel.getConnection());
            new JobChainBuilder((Job)loadKeysJob).runWhenDone((Job)new UIJob(""){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    IStatus status = loadKeysJob.getResult();
                    if (status.equals(Status.OK_STATUS)) {
                        GitCloningSettingsWizardPage.this.pageModel.setHasRemoteKeys(loadKeysJob.getKeys().size() > 0);
                        GitCloningSettingsWizardPage.this.setErrorMessage(null);
                        return Status.OK_STATUS;
                    }
                    GitCloningSettingsWizardPage.this.setErrorMessage(status.getMessage());
                    return status;
                }
            });
            WizardUtils.runInWizard((Job)loadKeysJob, (IWizardContainer)this.getContainer(), (DataBindingContext)dbc);
        }
        catch (Exception e) {
            StatusManager.getManager().handle(ExpressUIActivator.createErrorStatus("Could not load ssh keys.", e), 1);
        }
    }

    protected void onPageWillGetActivated(AbstractOpenShiftWizardPage.Direction direction, PageChangingEvent event, DataBindingContext dbc) {
        if (direction == AbstractOpenShiftWizardPage.Direction.FORWARDS) {
            this.pageModel.reset();
            dbc.updateTargets();
        }
    }

    private void enableWidgets(boolean isNewProject) {
        if (isNewProject) {
            this.useDefaultRepoPathButton.setEnabled(true);
            this.useDefaultRemoteNameButton.setEnabled(false);
            this.useDefaultRemoteNameButton.setSelection(true);
            this.remoteNameText.setEnabled(false);
            this.remoteNameLabel.setEnabled(false);
        } else {
            this.useDefaultRepoPathButton.setEnabled(false);
            this.useDefaultRemoteNameButton.setEnabled(true);
            this.remoteNameText.setEnabled(!this.useDefaultRemoteNameButton.getSelection());
            this.remoteNameLabel.setEnabled(!this.useDefaultRemoteNameButton.getSelection());
        }
    }

    class RemoteNameValidationStatusProvider
    extends MultiValidator {
        private final IObservableValue remoteNameObservable;
        private final IObservableValue projectNameObservable;

        public RemoteNameValidationStatusProvider(IObservableValue remoteNameTextObservable, IObservableValue projectNameObservable) {
            this.remoteNameObservable = remoteNameTextObservable;
            this.projectNameObservable = projectNameObservable;
        }

        protected IStatus validate() {
            IStatus status = Status.OK_STATUS;
            String remoteName = (String)this.remoteNameObservable.getValue();
            String projectName = (String)this.projectNameObservable.getValue();
            if (StringUtils.isEmpty((String)remoteName)) {
                return ExpressUIActivator.createErrorStatus("The custom remote name must not be empty.");
            }
            if (!remoteName.matches("\\S+")) {
                return ExpressUIActivator.createErrorStatus("The custom remote name must not contain spaces.");
            }
            if (!GitCloningSettingsWizardPage.this.pageModel.isNewProject() && this.hasRemoteName(remoteName, this.getProject(projectName))) {
                return ExpressUIActivator.createErrorStatus(NLS.bind((String)"The project {0} already has a remote named {1}.", (Object)projectName, (Object)remoteName));
            }
            return status;
        }

        public IProject getProject(String projectName) {
            if (StringUtils.isEmpty((String)projectName)) {
                return null;
            }
            return ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        }

        private boolean hasRemoteName(String remoteName, IProject project) {
            Repository repository;
            block5: {
                block4: {
                    try {
                        if (project != null && project.isAccessible()) break block4;
                        return false;
                    }
                    catch (Exception e) {
                        ExpressUIActivator.log(ExpressUIActivator.createErrorStatus(e.getMessage(), e));
                        return false;
                    }
                }
                repository = EGitUtils.getRepository((IProject)project);
                if (repository != null) break block5;
                return false;
            }
            return EGitUtils.hasRemote((String)remoteName, (Repository)repository);
        }

        public void forceRevalidate() {
            this.revalidate();
        }
    }

    class RepoPathValidationStatusProvider
    extends MultiValidator {
        private final IObservableValue repoPathObservable;
        private final IObservableValue applicationNameModelObservable;
        private final IObservableValue newProjectModelObservable;

        public RepoPathValidationStatusProvider(IObservableValue repoPathObservable, IObservableValue applicationNameModelObservable, IObservableValue newProjectModelObservable) {
            this.repoPathObservable = repoPathObservable;
            this.applicationNameModelObservable = applicationNameModelObservable;
            this.newProjectModelObservable = newProjectModelObservable;
        }

        protected IStatus validate() {
            String repoPath = (String)this.repoPathObservable.getValue();
            String applicationName = (String)this.applicationNameModelObservable.getValue();
            boolean newProject = (Boolean)this.newProjectModelObservable.getValue();
            if (newProject) {
                IPath applicationPath;
                Path repoResourcePath = new Path(repoPath);
                if (repoResourcePath.isEmpty() || !repoResourcePath.isAbsolute()) {
                    return ValidationStatus.cancel((String)"You need to provide an absolute path that we'll clone to.");
                }
                if (!FileUtils.canWrite((String)repoResourcePath.toOSString())) {
                    return ValidationStatus.error((String)NLS.bind((String)"The location {0} is not writeable.", (Object)repoResourcePath.toOSString()));
                }
                IPath iPath = applicationPath = applicationName != null ? repoResourcePath.append((IPath)new Path(applicationName)) : null;
                if (applicationPath != null && applicationPath.toFile().exists()) {
                    return ValidationStatus.error((String)NLS.bind((String)"The location \"{0}\" already contains a folder named \"{1}\"", (Object)repoResourcePath.toOSString(), (Object)applicationName));
                }
            }
            return ValidationStatus.ok();
        }

        public void forceRevalidate() {
            this.revalidate();
        }
    }
}

