/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.wizard.application;

import com.openshift.client.cartridge.ICartridge;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.jboss.tools.openshift.common.ui.wizard.AbstractOpenShiftWizard;
import org.jboss.tools.openshift.express.internal.core.connection.ExpressConnection;
import org.jboss.tools.openshift.express.internal.ui.wizard.application.IOpenShiftApplicationWizardModel;
import org.jboss.tools.openshift.express.internal.ui.wizard.application.NewApplicationProperties;
import org.jboss.tools.openshift.express.internal.ui.wizard.embed.AbstractCheckEmbeddableCartridgeStrategy;
import org.jboss.tools.openshift.express.internal.ui.wizard.embed.EmbeddedCartridgesWizardModel;
import org.jboss.tools.openshift.express.internal.ui.wizard.embed.EmbeddedCartridgesWizardPage;
import org.jboss.tools.openshift.express.internal.ui.wizard.embed.EmbeddedCartridgesWizardPageModel;

public class EditAlternativeCartridgesWizard
extends AbstractOpenShiftWizard<EmbeddedCartridgesWizardModel> {
    private EmbeddedCartridgesWizardPage editAlternativeCartridgesWizardPage;

    public EditAlternativeCartridgesWizard(ICartridge selectedAlternative, List<ICartridge> alternativeCartridges, IOpenShiftApplicationWizardModel wizardModel) {
        super("Add Embedded Cartridges", (Object)new EmbeddedCartridgesWizardModel(Collections.singleton(selectedAlternative), alternativeCartridges, new NewApplicationProperties(wizardModel), wizardModel.getDomain(), (ExpressConnection)wizardModel.getConnection()));
    }

    public boolean performFinish() {
        return true;
    }

    public void addPages() {
        this.editAlternativeCartridgesWizardPage = new EditAlternativeCartridgesWizardPage((EmbeddedCartridgesWizardModel)((Object)this.getModel()), (IWizard)this);
        this.addPage((IWizardPage)this.editAlternativeCartridgesWizardPage);
    }

    public ICartridge getCheckedCartridge() {
        Iterator<ICartridge> it = this.editAlternativeCartridgesWizardPage.getCheckedCartridges().iterator();
        if (!it.hasNext()) {
            return null;
        }
        return it.next();
    }

    protected static class EditAlternativeCartridgesWizardPage
    extends EmbeddedCartridgesWizardPage {
        EditAlternativeCartridgesWizardPage(EmbeddedCartridgesWizardModel wizardModel, IWizard wizard) {
            super("Select your cartridge", "Please select the cartridge that you want to add to your application.", wizardModel, wizard);
        }

        @Override
        protected ICheckStateListener onCartridgeChecked(EmbeddedCartridgesWizardPageModel pageModel, IWizardPage wizardPage) {
            return new SelectAlternativeStrategy(pageModel, wizardPage);
        }

        @Override
        protected void createButtons(Composite parent, DataBindingContext dbc) {
        }
    }

    private static class SelectAlternativeStrategy
    extends AbstractCheckEmbeddableCartridgeStrategy {
        SelectAlternativeStrategy(EmbeddedCartridgesWizardPageModel pageModel, IWizardPage wizardPage) {
            super(pageModel, wizardPage);
        }

        @Override
        protected void add(ICartridge cartridge, CheckStateChangedEvent event) {
            this.uncheckAllBut(cartridge);
        }

        private void uncheckAllBut(ICartridge cartridge) {
            this.getPageModel().uncheckAll();
            this.getPageModel().checkEmbeddedCartridge(cartridge);
        }

        @Override
        protected void remove(ICartridge cartridge, CheckStateChangedEvent event) {
            event.getCheckable().setChecked((Object)cartridge, true);
        }
    }
}

