/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.utils;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Logger;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import com.openshift.client.IApplication;
import com.openshift.client.OpenShiftSSHOperationException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.egit.ui.internal.credentials.EGitCredentialsProvider;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.CredentialsProviderUserInfo;
import org.eclipse.jgit.transport.JschConfigSessionFactory;
import org.eclipse.jgit.transport.OpenSshConfig;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.util.FS;
import org.eclipse.jsch.core.IJSchService;
import org.eclipse.jsch.ui.UserInfoPrompter;
import org.jboss.tools.openshift.express.internal.ui.ExpressUIActivator;
import org.jboss.tools.openshift.express.internal.ui.console.JschToEclipseLogger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class SSHSessionRepository
extends JschConfigSessionFactory {
    private static SSHSessionRepository INSTANCE = new SSHSessionRepository();
    private final IJSchService provider;
    private OpenSshConfig config;
    private final Map<URIish, Session> cache = new HashMap<URIish, Session>();

    public static SSHSessionRepository getInstance() {
        return INSTANCE;
    }

    SSHSessionRepository() {
        BundleContext context = ExpressUIActivator.getDefault().getBundle().getBundleContext();
        ServiceReference ssh = context.getServiceReference(IJSchService.class.getName());
        this.provider = (IJSchService)context.getService(ssh);
    }

    public Session getSession(IApplication application) throws OpenShiftSSHOperationException {
        try {
            URIish uri = SSHSessionRepository.getSshUri(application);
            Session session = this.cache.get(uri);
            if (session == null || !session.isConnected()) {
                FS fs = FS.DETECTED;
                if (this.config == null) {
                    this.config = OpenSshConfig.get((FS)fs);
                }
                String user = uri.getUser();
                String host = uri.getHost();
                int port = uri.getPort();
                JSch.setLogger((Logger)new JschToEclipseLogger());
                OpenSshConfig.Host hc = this.config.lookup(host);
                try {
                    this.cache.put(uri, this.createSession(hc, user, host, port, fs));
                }
                catch (JSchException e) {
                    throw new OpenShiftSSHOperationException((Throwable)e, "Could not create SSH session for application ''{0}''", new Object[]{application.getName()});
                }
            }
            return this.cache.get(uri);
        }
        catch (URISyntaxException e1) {
            throw new OpenShiftSSHOperationException((Throwable)e1, "Could not create SSH Session for application ''{0}''", new Object[]{application.getName()});
        }
    }

    static URIish getSshUri(IApplication application) throws URISyntaxException {
        URI sshURI = new URI(application.getSshUrl());
        String host = sshURI.getHost();
        String user = sshURI.getUserInfo();
        URIish uri = new URIish().setHost(host).setPort(22).setUser(user);
        return uri;
    }

    protected Session createSession(OpenSshConfig.Host hc, String user, String host, int port, FS fs) throws JSchException {
        JSch jsch = this.getJSch(hc, FS.DETECTED);
        if (jsch == this.provider.getJSch()) {
            Session session = this.provider.createSession(host, port, user);
            this.configure(hc, session);
            session.connect();
            return session;
        }
        Session session = jsch.getSession(user, host, port);
        this.configure(hc, session);
        session.connect(0);
        return session;
    }

    protected JSch createDefaultJSch(FS fs) throws JSchException {
        this.provider.createSession("127.0.0.1", 0, "eclipse");
        return this.provider.getJSch();
    }

    protected void configure(OpenSshConfig.Host hc, Session session) {
        EGitCredentialsProvider credentialsProvider = new EGitCredentialsProvider();
        if (!hc.isBatchMode() || !credentialsProvider.isInteractive()) {
            session.setUserInfo((UserInfo)new CredentialsProviderUserInfo(session, (CredentialsProvider)credentialsProvider));
        } else {
            UserInfo userInfo = session.getUserInfo();
            if (!hc.isBatchMode() && userInfo == null) {
                new UserInfoPrompter(session);
            }
        }
    }

    public static /* bridge */ /* synthetic */ SshSessionFactory getInstance() {
        return SSHSessionRepository.getInstance();
    }
}

