/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.job;

import com.openshift.client.IApplication;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.jboss.tools.openshift.express.internal.core.server.ExpressServerUtils;
import org.jboss.tools.openshift.express.internal.ui.ExpressUIActivator;

public class LoadApplicationJob
extends Job {
    private IApplication application = null;
    private final IServer server;

    public LoadApplicationJob(IServer server) {
        super(NLS.bind((String)"Identifying OpenShift Application for server adapter {0}...", (Object)server.getName()));
        this.server = server;
    }

    protected IStatus run(IProgressMonitor monitor) {
        this.application = ExpressServerUtils.getApplication((IServerAttributes)this.server);
        if (this.application == null) {
            return ExpressUIActivator.createErrorStatus(NLS.bind((String)"Failed to retrieve Application from server adapter {0}.\nPlease verify that the associated OpenShift application and workspace project still exist.", (Object)this.server.getName()));
        }
        return Status.OK_STATUS;
    }

    public final IApplication getApplication() {
        return this.application;
    }

    public String getApplicationName() {
        return this.server.getName();
    }
}

