/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.job;

import com.openshift.client.IApplication;
import com.openshift.client.IUser;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.openshift.common.core.connection.ConnectionsRegistry;
import org.jboss.tools.openshift.common.core.connection.ConnectionsRegistrySingleton;
import org.jboss.tools.openshift.common.core.connection.IConnection;
import org.jboss.tools.openshift.express.core.util.ExpressConnectionUtils;
import org.jboss.tools.openshift.express.internal.core.connection.ExpressConnection;
import org.jboss.tools.openshift.express.internal.core.util.ExpressResourceLabelUtils;
import org.jboss.tools.openshift.express.internal.ui.job.LoadApplicationJob;
import org.jboss.tools.openshift.internal.common.core.job.FireConnectionsChangedJob;

public class FireExpressConnectionsChangedJob
extends FireConnectionsChangedJob {
    private LoadApplicationJob job;

    public FireExpressConnectionsChangedJob(LoadApplicationJob job) {
        super(NLS.bind((String)"Refreshing connection for application {0}", (Object)job.getApplicationName()));
        this.job = job;
    }

    public FireExpressConnectionsChangedJob(IUser user) {
        super(NLS.bind((String)"Refreshing connection {0}", (Object)user.getRhlogin()));
        this.add(this.createConnection(user));
    }

    public FireExpressConnectionsChangedJob(List<IUser> users) {
        super(NLS.bind((String)"Refreshing {0} connections", (Object)users.size()));
        this.add(this.createConnections(users));
    }

    public FireExpressConnectionsChangedJob(ExpressConnection connection) {
        super(NLS.bind((String)"Refreshing connection {0}", (Object)ExpressResourceLabelUtils.toString((ExpressConnection)connection)));
        this.add((IConnection)connection);
    }

    protected List<IConnection> getConnections() {
        if (!this.connections.isEmpty()) {
            return this.connections;
        }
        if (this.job != null) {
            return Collections.singletonList(this.createConnection(this.job.getApplication()));
        }
        return Collections.emptyList();
    }

    private void add(Collection<IConnection> connections) {
        for (IConnection connection : connections) {
            this.add(connection);
        }
    }

    private void add(IConnection connection) {
        if (connection != null) {
            this.connections.add(connection);
        }
    }

    private Collection<IConnection> createConnections(List<IUser> users) {
        HashSet<IConnection> connections = new HashSet<IConnection>();
        if (users == null) {
            return connections;
        }
        for (IUser user : users) {
            connections.add(this.createConnection(user));
        }
        return connections;
    }

    private IConnection createConnection(IUser user) {
        return ExpressConnectionUtils.getByResource((IUser)user, (ConnectionsRegistry)ConnectionsRegistrySingleton.getInstance());
    }

    private IConnection createConnection(IApplication application) {
        if (application == null || application.getDomain() == null) {
            return null;
        }
        return this.createConnection(application.getDomain().getUser());
    }
}

