/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.job;

import com.openshift.client.IDomain;
import com.openshift.client.IUser;
import com.openshift.client.OpenShiftException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.openshift.common.core.connection.ConnectionsRegistry;
import org.jboss.tools.openshift.common.core.connection.ConnectionsRegistrySingleton;
import org.jboss.tools.openshift.common.core.connection.IConnection;
import org.jboss.tools.openshift.express.core.util.ExpressConnectionUtils;
import org.jboss.tools.openshift.express.internal.core.connection.ExpressConnection;
import org.jboss.tools.openshift.express.internal.ui.ExpressUIMessages;
import org.jboss.tools.openshift.internal.common.core.job.AbstractDelegatingMonitorJob;

public class DestroyDomainJob
extends AbstractDelegatingMonitorJob {
    private IDomain domain;
    private boolean force;

    public DestroyDomainJob(IDomain domain, boolean force) {
        super(NLS.bind((String)ExpressUIMessages.DESTROYING_DOMAIN, (Object)domain.getId()));
        this.domain = domain;
        this.force = force;
    }

    protected IStatus doRun(IProgressMonitor monitor) {
        try {
            this.domain.destroy(this.force);
            ExpressConnection connection = ExpressConnectionUtils.getByResource((IUser)this.domain.getUser(), (ConnectionsRegistry)ConnectionsRegistrySingleton.getInstance());
            ConnectionsRegistrySingleton.getInstance().fireConnectionChanged((IConnection)connection);
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        catch (OpenShiftException e) {
            Status status = new Status(4, "org.jboss.tools.openshift.express.ui", NLS.bind((String)"Failed to destroy domain \"{0}\"", (Object)this.domain.getId()), (Throwable)e);
            return status;
        }
        finally {
            monitor.done();
        }
    }
}

