/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.job;

import com.openshift.client.IApplication;
import com.openshift.client.OpenShiftException;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.openshift.express.internal.ui.ExpressUIActivator;
import org.jboss.tools.openshift.express.internal.ui.ExpressUIMessages;
import org.jboss.tools.openshift.express.internal.ui.job.LoadApplicationJob;
import org.jboss.tools.openshift.internal.common.core.job.AbstractDelegatingMonitorJob;

public class DeleteApplicationsJob
extends AbstractDelegatingMonitorJob {
    private List<IApplication> applications;
    private LoadApplicationJob job;

    public DeleteApplicationsJob(LoadApplicationJob job) {
        super(ExpressUIMessages.DeletingOpenShiftApplications);
        this.job = job;
    }

    public DeleteApplicationsJob(List<IApplication> applications) {
        super(ExpressUIMessages.DeletingOpenShiftApplications);
        this.applications = applications;
    }

    protected IStatus doRun(IProgressMonitor monitor) {
        List<IApplication> applications = this.getApplications();
        int totalWork = applications.size();
        monitor.beginTask(ExpressUIMessages.DeletingOpenShiftApplications, totalWork);
        try {
            for (IApplication application : applications) {
                String appName;
                block10: {
                    if (application == null) {
                        monitor.worked(1);
                        continue;
                    }
                    appName = application.getName();
                    try {
                        if (!monitor.isCanceled()) break block10;
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    catch (OpenShiftException e) {
                        IStatus iStatus = ExpressUIActivator.createErrorStatus(NLS.bind((String)ExpressUIMessages.FailedToDeleteApplication, (Object)appName), e);
                        monitor.done();
                        return iStatus;
                    }
                }
                monitor.setTaskName(NLS.bind((String)ExpressUIMessages.DeletingApplication, (Object)appName));
                application.destroy();
                monitor.worked(1);
            }
        }
        finally {
            monitor.done();
        }
        return Status.OK_STATUS;
    }

    private List<IApplication> getApplications() {
        if (this.applications != null) {
            return this.applications;
        }
        return Collections.singletonList(this.job.getApplication());
    }
}

