/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.filters;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.eclipse.ui.IActionFilter;

public class SimplePropertyActionFilter
implements IActionFilter {
    private static final int NAME_CAPTURE_GROUP = 2;
    private final Pattern simpleAccessorPattern = Pattern.compile("(get|is)([a-zA-Z_0-9]*)");

    public boolean testAttribute(Object target, String name, String desiredValue) {
        if (target == null) {
            return false;
        }
        Method accessor = this.findAttribute(target, name);
        if (accessor == null) {
            return false;
        }
        try {
            Object value = accessor.invoke(target, new Object[0]);
            return value != null && desiredValue.equals(value.toString());
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (InvocationTargetException invocationTargetException) {}
        return false;
    }

    private Method findAttribute(Object target, String name) {
        Method[] methods = target.getClass().getMethods();
        int i = 0;
        while (i < methods.length) {
            if (this.isAccessorFor(name, methods[i].getName())) {
                return methods[i];
            }
            ++i;
        }
        return null;
    }

    private boolean isAccessorFor(String property, String accessorName) {
        Matcher matcher = this.simpleAccessorPattern.matcher(accessorName);
        if (matcher.lookingAt()) {
            return property.equals(StringUtils.uncapitalize((String)matcher.group(2)));
        }
        return false;
    }
}

