/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.explorer;

import com.openshift.client.IApplication;
import com.openshift.client.IDomain;
import com.openshift.client.OpenShiftException;
import com.openshift.client.cartridge.ICartridge;
import com.openshift.client.cartridge.IEmbeddedCartridge;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.jboss.tools.openshift.common.core.utils.StringUtils;
import org.jboss.tools.openshift.express.internal.core.connection.ExpressConnection;
import org.jboss.tools.openshift.express.internal.core.util.ExpressResourceLabelUtils;
import org.jboss.tools.openshift.express.internal.ui.ExpressImages;
import org.jboss.tools.openshift.express.internal.ui.ExpressUIMessages;
import org.jboss.tools.openshift.internal.common.ui.explorer.BaseExplorerContentProvider;
import org.jboss.tools.openshift.internal.common.ui.explorer.BaseExplorerLabelProvider;

public class ExpressExplorerLabelProvider
extends BaseExplorerLabelProvider {
    private static final String DEFAULT_MARKER = "(default)";

    public Image getImage(Object element) {
        if (element instanceof IDomain) {
            return ExpressImages.GLOBE_IMG;
        }
        if (element instanceof IApplication) {
            return ExpressImages.QUERY_IMG;
        }
        if (element instanceof IEmbeddedCartridge) {
            return ExpressImages.TASK_REPO_IMG;
        }
        return super.getImage(element);
    }

    public String getText(Object element) {
        return this.getStyledText(element).getString();
    }

    public StyledString getStyledText(Object element) {
        if (element instanceof ExpressConnection) {
            return this.createStyledString((ExpressConnection)element);
        }
        if (element instanceof IDomain) {
            return this.createStyledString((IDomain)element);
        }
        if (element instanceof IApplication) {
            return this.createStyledString((IApplication)element);
        }
        if (element instanceof IEmbeddedCartridge) {
            return this.createStyledString((IEmbeddedCartridge)element);
        }
        if (element instanceof BaseExplorerContentProvider.LoadingStub) {
            return new StyledString(ExpressUIMessages.LOADING_USER_APPLICATIONS_LABEL);
        }
        if (element instanceof BaseExplorerContentProvider.NotConnectedUserStub) {
            return new StyledString(ExpressUIMessages.USER_NOT_CONNECTED_LABEL);
        }
        if (element instanceof OpenShiftException) {
            return new StyledString(((OpenShiftException)((Object)element)).getMessage());
        }
        return super.getStyledText(element);
    }

    private StyledString createStyledString(ExpressConnection connection) {
        String name = StringUtils.null2emptyString((String)connection.getUsername());
        String host = StringUtils.null2emptyString((String)connection.getHost());
        StringBuilder builder = new StringBuilder(name).append(' ').append(host);
        if (connection.isDefaultHost()) {
            builder.append(' ').append(DEFAULT_MARKER);
        }
        String label = builder.toString();
        StyledString styledString = new StyledString(label);
        styledString.setStyle(name.length() + 1, builder.length() - name.length() - 1, StyledString.QUALIFIER_STYLER);
        return styledString;
    }

    private StyledString createStyledString(IDomain domain) {
        String id = domain.getId();
        String fullName = ExpressResourceLabelUtils.toString((IDomain)domain);
        String label = id + ' ' + fullName;
        StyledString styledString = new StyledString(label);
        styledString.setStyle(id.length() + 1, fullName.length(), StyledString.QUALIFIER_STYLER);
        return styledString;
    }

    private StyledString createStyledString(IApplication application) {
        String appName = application.getName();
        String appType = StringUtils.null2emptyString((String)ExpressResourceLabelUtils.toString((ICartridge)application.getCartridge()));
        StringBuilder sb = new StringBuilder(appName).append(' ').append(appType);
        StyledString styledString = new StyledString(sb.toString());
        styledString.setStyle(appName.length() + 1, appType.length(), StyledString.QUALIFIER_STYLER);
        return styledString;
    }

    private StyledString createStyledString(IEmbeddedCartridge cartridge) {
        String displayName = cartridge.getDisplayName();
        String name = cartridge.getName();
        StringBuilder sb = new StringBuilder(displayName).append(' ').append(name);
        StyledString styledString = new StyledString(sb.toString());
        styledString.setStyle(displayName.length() + 1, name.length(), StyledString.QUALIFIER_STYLER);
        return styledString;
    }
}

