/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.command;

import com.openshift.client.IApplication;
import com.openshift.client.IDomain;
import com.openshift.client.IOpenShiftResource;
import com.openshift.client.IUser;
import com.openshift.client.OpenShiftException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jboss.tools.openshift.common.core.connection.ConnectionsRegistry;
import org.jboss.tools.openshift.common.core.connection.ConnectionsRegistrySingleton;
import org.jboss.tools.openshift.common.core.connection.IConnection;
import org.jboss.tools.openshift.express.core.util.ExpressConnectionUtils;
import org.jboss.tools.openshift.express.internal.ui.ExpressUIActivator;
import org.jboss.tools.openshift.internal.common.core.job.AbstractDelegatingMonitorJob;
import org.jboss.tools.openshift.internal.common.core.job.FireConnectionsChangedJob;
import org.jboss.tools.openshift.internal.common.core.job.JobChainBuilder;
import org.jboss.tools.openshift.internal.common.ui.utils.UIUtils;

public class RefreshResourceHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        Object resource = this.getResource(selection);
        if (resource != null) {
            this.refresh(resource);
        }
        return null;
    }

    private Object getResource(ISelection selection) {
        Object resource = UIUtils.getFirstElement((ISelection)selection, IOpenShiftResource.class);
        if (resource == null) {
            resource = UIUtils.getFirstElement((ISelection)selection, IConnection.class);
        }
        return resource;
    }

    private void refresh(final Object element) {
        AbstractDelegatingMonitorJob job = new AbstractDelegatingMonitorJob("Loading OpenShift information..."){

            protected IStatus doRun(IProgressMonitor monitor) {
                try {
                    try {
                        monitor.beginTask("Loading OpenShift informations...", -1);
                        if (element instanceof IConnection) {
                            ((IConnection)element).refresh();
                        } else if (element instanceof IOpenShiftResource) {
                            ((IOpenShiftResource)element).refresh();
                        }
                    }
                    catch (OpenShiftException e) {
                        ExpressUIActivator.log("Failed to refresh element", e);
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        };
        IConnection connection = this.getConnection(element);
        if (connection != null) {
            new JobChainBuilder((Job)job).runWhenSuccessfullyDone((Job)new FireConnectionsChangedJob(connection)).schedule();
        } else {
            job.schedule();
        }
    }

    private IConnection getConnection(Object resource) {
        IConnection connection = null;
        if (resource instanceof IConnection) {
            connection = (IConnection)resource;
        } else if (resource instanceof IDomain) {
            IDomain domain = (IDomain)resource;
            connection = ExpressConnectionUtils.getByResource((IUser)domain.getUser(), (ConnectionsRegistry)ConnectionsRegistrySingleton.getInstance());
        } else if (resource instanceof IApplication) {
            IApplication application = (IApplication)resource;
            connection = ExpressConnectionUtils.getByResource((IApplication)application, (ConnectionsRegistry)ConnectionsRegistrySingleton.getInstance());
        }
        return connection;
    }
}

