/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui;

import com.openshift.client.IHttpClient;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.jboss.tools.openshift.common.core.ICredentialsPrompter;
import org.jboss.tools.openshift.common.ui.connection.CredentialsPrompter;
import org.jboss.tools.openshift.express.core.ExpressCoreUIIntegration;
import org.jboss.tools.openshift.express.core.IConsoleUtility;
import org.jboss.tools.openshift.express.core.IQuestionHandler;
import org.jboss.tools.openshift.express.internal.ui.QuestionHandler;
import org.jboss.tools.openshift.express.internal.ui.console.ConsoleUtils;
import org.jboss.tools.openshift.express.internal.ui.wizard.connection.SSLCertificateCallback;
import org.osgi.framework.BundleContext;

public class ExpressUIActivator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.jboss.tools.openshift.express.ui";
    private static ExpressUIActivator plugin;
    private IPreferenceStore corePreferenceStore = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.jboss.tools.openshift.express.core");

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.initCoreUIIntegration();
    }

    protected void initCoreUIIntegration() {
        ExpressCoreUIIntegration.getDefault().setQuestionHandler((IQuestionHandler)new QuestionHandler());
        ExpressCoreUIIntegration.getDefault().setConsoleUtility((IConsoleUtility)new ConsoleUtils());
        ExpressCoreUIIntegration.getDefault().setCredentialPrompter((ICredentialsPrompter)new CredentialsPrompter());
        ExpressCoreUIIntegration.getDefault().setSSLCertificateAuthorization((IHttpClient.ISSLCertificateCallback)new SSLCertificateCallback());
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static ExpressUIActivator getDefault() {
        return plugin;
    }

    public static void log(IStatus status) {
        plugin.getLog().log(status);
    }

    public static void log(String message) {
        ExpressUIActivator.log(message, null);
    }

    public static void log(Throwable e) {
        ExpressUIActivator.log(e.getMessage(), e);
    }

    public static void log(String message, Throwable e) {
        ExpressUIActivator.log((IStatus)new Status(4, PLUGIN_ID, 4, message, e));
    }

    public static IStatus createCancelStatus(String message) {
        return new Status(8, PLUGIN_ID, message);
    }

    public static IStatus createCancelStatus(String message, Object ... arguments) {
        return new Status(8, PLUGIN_ID, NLS.bind((String)message, (Object[])arguments));
    }

    public static IStatus createErrorStatus(String message) {
        return new Status(4, PLUGIN_ID, message);
    }

    public static IStatus createErrorStatus(String message, Throwable throwable) {
        return new Status(4, PLUGIN_ID, message, throwable);
    }

    public static IStatus createErrorStatus(String message, Throwable throwable, Object ... arguments) {
        return ExpressUIActivator.createErrorStatus(NLS.bind((String)message, (Object[])arguments), throwable);
    }

    public static MultiStatus createMultiStatus(String message, Throwable t, Object ... arguments) {
        MultiStatus multiStatus = new MultiStatus(PLUGIN_ID, 4, NLS.bind((String)message, (Object[])arguments), t);
        ExpressUIActivator.addStatuses(t, multiStatus);
        return multiStatus;
    }

    private static void addStatuses(Throwable t, MultiStatus multiStatus) {
        Throwable wrapped = ExpressUIActivator.getWrappedThrowable(t);
        if (wrapped != null) {
            multiStatus.add(ExpressUIActivator.createErrorStatus(wrapped.getMessage(), wrapped));
            ExpressUIActivator.addStatuses(wrapped, multiStatus);
        }
    }

    private static Throwable getWrappedThrowable(Throwable t) {
        if (t instanceof InvocationTargetException) {
            return ((InvocationTargetException)t).getTargetException();
        }
        if (t instanceof Exception) {
            return ((Exception)t).getCause();
        }
        return null;
    }

    public IPreferenceStore getCorePreferenceStore() {
        if (this.corePreferenceStore == null) {
            this.corePreferenceStore = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.jboss.tools.openshift.express.core");
        }
        return this.corePreferenceStore;
    }
}

