/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.common.core.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Scanner;
import java.util.concurrent.Callable;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.Platform;
import org.jboss.tools.openshift.internal.common.core.util.CommandLocationBinary;
import org.jboss.tools.openshift.internal.common.core.util.ThreadUtils;

public class CommandLocationLookupStrategy {
    private static final String LINUX_WHICH = "which ";
    private static final String WINDOWS_WHERE = "where ";
    private static final String LINUX_PATHVAR = "PATH";
    private static final String WINDOWS_PATHVAR = "Path";
    public static final CommandLocationLookupStrategy WINDOWS_STRATEGY = new CommandLocationLookupStrategy("where ", ";", "Path", new String[]{".exe", ".com"});
    public static final CommandLocationLookupStrategy LINUX_STRATEGY = new CommandLocationLookupStrategy("which ", ":", "PATH", new String[0]);
    private String which;
    private String delim;
    private String pathvar;
    private String[] suffixes;

    public static CommandLocationLookupStrategy get() {
        String os = Platform.getOS();
        if ("win32".equals(os)) {
            return WINDOWS_STRATEGY;
        }
        return LINUX_STRATEGY;
    }

    public CommandLocationLookupStrategy(String which, String delim, String pathvar, String[] suffixes) {
        this.which = which;
        this.delim = delim;
        this.pathvar = pathvar;
        this.suffixes = suffixes;
    }

    public String search(CommandLocationBinary binary) {
        return this.search(binary, 2000);
    }

    public String search(CommandLocationBinary binary, int timeout) {
        String cmd = binary.getCommand(Platform.getOS());
        String defaultLoc = binary.getDefaultLoc(Platform.getOS());
        return this.findLocation(defaultLoc, cmd, this.which, this.delim, this.pathvar, timeout);
    }

    private String findLocation(String defaultLoc, String cmd, String which, String delim, String pathvar, int timeout) {
        if (defaultLoc != null && new File(defaultLoc).exists()) {
            return defaultLoc;
        }
        String ret = this.searchPath(System.getenv(pathvar), delim, cmd);
        if (ret == null) {
            ret = this.runCommand(String.valueOf(which) + cmd, timeout);
        }
        return ret;
    }

    private String[] getPossibleCommandNames(String commandName) {
        ArrayList<String> ret = new ArrayList<String>(5);
        ret.add(commandName);
        int i = 0;
        while (i < this.suffixes.length) {
            ret.add(String.valueOf(commandName) + this.suffixes[i]);
            ++i;
        }
        return ret.toArray(new String[ret.size()]);
    }

    private String searchPath(String path, String delim, String commandName) {
        String[] roots = path.split(delim);
        String[] withSuffixes = this.getPossibleCommandNames(commandName);
        int i = 0;
        while (i < roots.length) {
            int j = 0;
            while (j < withSuffixes.length) {
                File test = new File(roots[i], withSuffixes[j]);
                if (test.exists()) {
                    return test.getAbsolutePath();
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    private String runCommand(final String cmd, int timeout) {
        if (timeout == -1) {
            return this.runCommand(cmd);
        }
        String path = ThreadUtils.runWithTimeout(timeout, new Callable<String>(){

            @Override
            public String call() throws Exception {
                return CommandLocationLookupStrategy.this.runCommand(cmd);
            }
        });
        return path;
    }

    private String runCommand(String cmd) {
        Process p = null;
        try {
            p = Runtime.getRuntime().exec(cmd);
            try {
                p.waitFor();
            }
            catch (InterruptedException interruptedException) {}
            if (p.exitValue() == 0) {
                String cmdOutput;
                InputStream is = p.getInputStream();
                Scanner s = new Scanner(is).useDelimiter("\\A");
                String string = cmdOutput = s.hasNext() ? s.next() : "";
                if (!cmdOutput.isEmpty() && new File(cmdOutput = StringUtils.trim((String)cmdOutput)).exists()) {
                    String string2 = cmdOutput;
                    return string2;
                }
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (p != null) {
                p.destroy();
            }
        }
        return null;
    }
}

