/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.common.core.utils;

import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.variables.VariablesPlugin;
import org.jboss.tools.openshift.common.core.OpenShiftCoreException;
import org.jboss.tools.openshift.internal.common.core.OpenShiftCommonCoreActivator;

public class VariablesHelper {
    public static final String VARIABLE_PREFIX = "${";
    public static final String VARIABLE_SUFFIX = "}";
    public static final String WORKSPACE_LOC = "workspace_loc";
    public static final String WORKSPACE_PREFIX = "${workspace_loc:";

    private VariablesHelper() {
    }

    public static boolean containsVariables(String value) {
        return StringUtils.isNotBlank((String)value) && value.indexOf(VARIABLE_PREFIX) < value.indexOf(VARIABLE_SUFFIX);
    }

    public static String addWorkspacePrefix(String value) {
        if (StringUtils.isBlank((String)value) || value.startsWith(WORKSPACE_PREFIX)) {
            return value;
        }
        return VariablesPlugin.getDefault().getStringVariableManager().generateVariableExpression(WORKSPACE_LOC, value);
    }

    public static String getWorkspacePath(String value) {
        if (StringUtils.isBlank((String)value) || !value.startsWith(WORKSPACE_PREFIX) || !value.endsWith(VARIABLE_SUFFIX)) {
            return value;
        }
        String path = value.substring(WORKSPACE_PREFIX.length(), value.length() - 1);
        return path;
    }

    public static String replaceVariables(String value) {
        return VariablesHelper.replaceVariables(value, false);
    }

    public static String replaceVariables(String value, boolean ignoreErrors) {
        if (VariablesHelper.containsVariables(value)) {
            try {
                return VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(value);
            }
            catch (CoreException e) {
                if (ignoreErrors) {
                    OpenShiftCommonCoreActivator.log("Could not interpolate " + value, e);
                }
                throw new OpenShiftCoreException(e);
            }
        }
        return value;
    }
}

