/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.common.core.utils;

import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.xml.bind.DatatypeConverter;
import org.eclipse.core.runtime.Assert;
import org.jboss.tools.openshift.common.core.utils.StringUtils;

public class UrlUtils {
    public static final String HTTP = "http";
    public static final String HTTPS = "https";
    public static final String SCHEME_TERMINATOR = ":";
    public static final String SCHEME_SEPARATOR = "://";
    public static final String SCHEME_HTTPS = "https://";
    public static final String SCHEME_HTTP = "http://";
    public static final char CREDENTIALS_HOST_SEPARATOR = '@';
    public static final char PORT_DELIMITER = ':';
    private static final Pattern SIMPLE_URL_PATTERN = Pattern.compile("(\\w+://)(.+@)*([\\w\\d\\.]+)(:[\\d]+){0,1}/*(.*)");
    private static final Pattern SIMPLE_QUASI_URL_PATTERN = Pattern.compile("^((\\w+:/)?(/*)?(.*@)?)([^:|/]*)(.*)?$");
    private static final String PROPERTY_BASIC = "Basic";
    private static final String PROPERTY_AUTHORIZATION = "Authorization";

    private UrlUtils() {
    }

    public static UrlPortions toPortions(String url) throws UnsupportedEncodingException, MalformedURLException {
        return new UrlPortions(new URL(url));
    }

    public static UrlPortions toPortions(URL url) throws UnsupportedEncodingException {
        return new UrlPortions(url);
    }

    public static String ensureStartsWithScheme(String hostUrl, String defaultScheme) throws IllegalArgumentException {
        Assert.isLegal((!UrlUtils.isEmpty(defaultScheme) ? 1 : 0) != 0, (String)"Default scheme is empty");
        if (UrlUtils.isEmpty(hostUrl)) {
            return hostUrl;
        }
        if (hostUrl.indexOf(SCHEME_SEPARATOR) == -1) {
            return String.valueOf(defaultScheme) + hostUrl;
        }
        return hostUrl;
    }

    public static String cutScheme(String host) {
        if (UrlUtils.isEmpty(host)) {
            return host;
        }
        int hostIndex = UrlUtils.getHostIndex(host);
        if (hostIndex > -1) {
            return host.substring(hostIndex);
        }
        return host;
    }

    public static String getScheme(String url) {
        if (UrlUtils.isEmpty(url)) {
            return null;
        }
        int hostIndex = UrlUtils.getHostIndex(url);
        if (hostIndex == -1) {
            return null;
        }
        return url.substring(0, hostIndex);
    }

    public static boolean hasScheme(String host) {
        if (UrlUtils.isEmpty(host)) {
            return false;
        }
        return host.contains(SCHEME_SEPARATOR);
    }

    public static String getHost(String url) {
        Matcher m;
        if (UrlUtils.isEmpty(url)) {
            return url;
        }
        String host = null;
        if (url.contains(SCHEME_SEPARATOR)) {
            try {
                host = new URI(url).getHost();
            }
            catch (URISyntaxException uRISyntaxException) {}
        }
        if (host == null && (m = SIMPLE_QUASI_URL_PATTERN.matcher(url)).find()) {
            host = m.group(5);
        }
        return host;
    }

    private static int getHostIndex(String url) {
        int schemeSeparatorIndex = url.indexOf(SCHEME_SEPARATOR);
        if (schemeSeparatorIndex == -1) {
            return schemeSeparatorIndex;
        }
        return schemeSeparatorIndex + SCHEME_SEPARATOR.length();
    }

    private static boolean isEmpty(String string) {
        return string == null || string.isEmpty();
    }

    public static String cutPort(String host) {
        if (UrlUtils.isEmpty(host)) {
            return host;
        }
        int portIndex = UrlUtils.getPortIndex(host);
        if (portIndex > -1) {
            return host.substring(0, portIndex);
        }
        return host;
    }

    private static int getPortIndex(String url) {
        int portSeparatorIndex = url.indexOf(58);
        if (portSeparatorIndex == -1) {
            return portSeparatorIndex;
        }
        return portSeparatorIndex;
    }

    public static String getUrlFor(String username, String host, String scheme) throws UnsupportedEncodingException {
        StringBuilder builder = new StringBuilder();
        if (!UrlUtils.isEmpty(scheme)) {
            builder.append(scheme);
        }
        if (!UrlUtils.isEmpty(username)) {
            builder.append(URLEncoder.encode(username, "UTF-8")).append('@');
        }
        if (!UrlUtils.isEmpty(host = UrlUtils.cutScheme(host))) {
            builder.append(host);
        }
        return builder.toString();
    }

    public static String getUrlFor(String username, String host) throws UnsupportedEncodingException, IllegalArgumentException {
        String scheme = UrlUtils.getScheme(host);
        Assert.isLegal((!UrlUtils.isEmpty(scheme) ? 1 : 0) != 0, (String)MessageFormat.format("Could not extract scheme. Host {0} has no scheme", host));
        return UrlUtils.getUrlFor(username, host, scheme);
    }

    public static boolean isEmptyHost(String host) {
        try {
            return StringUtils.isEmpty(host) || new URL(UrlUtils.ensureStartsWithScheme(host, SCHEME_HTTPS)).getHost().isEmpty();
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
    }

    public static boolean isValid(String url) {
        if (SIMPLE_URL_PATTERN.matcher(url).matches()) {
            try {
                new URI(url);
                new URL(url);
            }
            catch (MalformedURLException | URISyntaxException exception) {
                return false;
            }
            return true;
        }
        return false;
    }

    public static void setupPermissiveSSLHandlers(HttpsURLConnection connection) throws KeyManagementException, NoSuchAlgorithmException {
        SSLContext sslContext = SSLContext.getInstance("SSL");
        sslContext.init(null, new TrustManager[]{new PermissiveTrustManager()}, null);
        SSLSocketFactory socketFactory = sslContext.getSocketFactory();
        connection.setSSLSocketFactory(socketFactory);
        connection.setHostnameVerifier(new PermissiveHostnameVerifier());
    }

    public static void addBasicAuthorization(String username, String password, HttpURLConnection connection) {
        String credentials = UrlUtils.toBase64Encoded(username + ':' + password);
        connection.setRequestProperty(PROPERTY_AUTHORIZATION, PROPERTY_BASIC + ' ' + credentials);
    }

    public static String toBase64Encoded(String unencoded) {
        if (unencoded == null) {
            return null;
        }
        if (unencoded.getBytes().length == 0) {
            return new String();
        }
        return DatatypeConverter.printBase64Binary((byte[])unencoded.getBytes());
    }

    private static class PermissiveHostnameVerifier
    implements HostnameVerifier {
        private PermissiveHostnameVerifier() {
        }

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    }

    private static class PermissiveTrustManager
    implements X509TrustManager {
        private PermissiveTrustManager() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }
    }

    public static class UrlPortions {
        private String protocol;
        private String username;
        private String password;
        private String host;
        private int port;

        private UrlPortions(URL url) throws UnsupportedEncodingException {
            String userInfo = url.getUserInfo();
            if (userInfo != null) {
                String[] userInfos = url.getUserInfo().split(UrlUtils.SCHEME_TERMINATOR);
                if (userInfos.length >= 1) {
                    this.username = URLDecoder.decode(userInfos[0], "UTF-8");
                }
                if (userInfos.length >= 2) {
                    this.password = userInfos[1];
                }
            }
            this.host = url.getHost();
            this.protocol = url.getProtocol();
            this.port = url.getPort();
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }

        public String getHost() {
            return this.host;
        }

        public String getScheme() {
            return String.valueOf(this.protocol) + UrlUtils.SCHEME_SEPARATOR;
        }

        public int getPort() {
            return this.port;
        }
    }
}

