/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.common.core.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.openshift.internal.common.core.OpenShiftCommonCoreActivator;
import org.osgi.framework.Bundle;

public class ExtensionUtils {
    private ExtensionUtils() {
    }

    public static Collection<IConfigurationElement> getExtensionConfigurations(String extensionId) {
        return Arrays.asList(Platform.getExtensionRegistry().getConfigurationElementsFor(extensionId));
    }

    public static <T> Collection<T> getExtensions(String extensionId, String classAttribute) {
        IConfigurationElement[] config;
        ArrayList<T> extensions = new ArrayList<T>();
        IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor(extensionId);
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            T extension = ExtensionUtils.safeCreateExtension(extensionId, classAttribute, configurationElement);
            if (extension != null) {
                extensions.add(extension);
            }
            ++n2;
        }
        return extensions;
    }

    public static <T> T getFirstExtension(String extensionId, String classAttribute) {
        IConfigurationElement[] config = Platform.getExtensionRegistry().getConfigurationElementsFor(extensionId);
        if (config.length == 0) {
            return null;
        }
        return ExtensionUtils.safeCreateExtension(extensionId, classAttribute, config[0]);
    }

    public static <T> T safeCreateExtension(String extensionId, String classAttribute, IConfigurationElement configurationElement) {
        try {
            return ExtensionUtils.createExtension(classAttribute, configurationElement);
        }
        catch (ClassNotFoundException | IllegalArgumentException | IllegalStateException e) {
            OpenShiftCommonCoreActivator.log(NLS.bind((String)"Could not create extension {0} in bundle {1}", (Object)configurationElement.getName(), (Object)ExtensionUtils.getBundleNameFor(configurationElement)), e);
            return null;
        }
    }

    public static <T> T createExtension(String classAttribute, IConfigurationElement configurationElement) throws IllegalStateException, IllegalArgumentException, ClassNotFoundException {
        String className = configurationElement.getAttribute(classAttribute);
        if (className == null) {
            return null;
        }
        return ExtensionUtils.createInstance(className, configurationElement);
    }

    public static <T> T createInstance(String className, IConfigurationElement configurationElement) throws IllegalStateException, IllegalArgumentException, ClassNotFoundException {
        T object;
        block4: {
            Class<T> clazz = ExtensionUtils.getClass(className, configurationElement);
            if (clazz == null) {
                return null;
            }
            object = clazz.newInstance();
            if (object != null) break block4;
            return null;
        }
        try {
            return object;
        }
        catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
            throw new IllegalStateException(NLS.bind((String)"Could not instantiate class {0}", (Object)className));
        }
    }

    public static <T> Class<T> getClass(String className, IConfigurationElement configurationElement) throws IllegalStateException, IllegalArgumentException, ClassNotFoundException {
        if (className == null) {
            throw new IllegalArgumentException("No class name provided");
        }
        String bundleName = ExtensionUtils.getBundleNameFor(configurationElement);
        Bundle bundle = Platform.getBundle((String)bundleName);
        if (bundle == null) {
            throw new IllegalStateException(NLS.bind((String)"Could not find bundle {0} for extension {1}", (Object)bundleName, (Object)configurationElement.getName()));
        }
        return bundle.loadClass(className);
    }

    public static String getBundleNameFor(IConfigurationElement configurationElement) {
        return configurationElement.getDeclaringExtension().getContributor().getName();
    }
}

