/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.common.core.connection;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jboss.tools.openshift.common.core.connection.IConnection;
import org.jboss.tools.openshift.common.core.connection.IConnectionFactory;
import org.jboss.tools.openshift.common.core.connection.IConnectionsFactory;
import org.jboss.tools.openshift.common.core.utils.StringUtils;

public class ConnectionsFactory
implements IConnectionsFactory {
    private Set<IConnectionFactory> connectionFactories = new CopyOnWriteArraySet<IConnectionFactory>();

    @Override
    public IConnection create(String host) throws IOException {
        for (IConnectionFactory factory : this.connectionFactories) {
            IConnection connection = factory.create(host);
            if (!connection.canConnect()) continue;
            return connection;
        }
        return null;
    }

    @Override
    public IConnectionFactory getFactory(String host) throws IOException {
        for (IConnectionFactory factory : this.connectionFactories) {
            IConnection connection = factory.create(host);
            if (!connection.canConnect()) continue;
            return factory;
        }
        return null;
    }

    public void addConnectionFactory(IConnectionFactory factory) {
        this.connectionFactories.add(factory);
    }

    public void removeConnectionFactory(IConnectionFactory factory) {
        this.connectionFactories.remove(factory);
    }

    @Override
    public IConnectionFactory getById(String id) {
        if (StringUtils.isEmpty(id)) {
            return null;
        }
        IConnectionFactory matchingFactory = null;
        for (IConnectionFactory factory : this.connectionFactories) {
            if (!id.equals(factory.getId())) continue;
            matchingFactory = factory;
            break;
        }
        return matchingFactory;
    }

    @Override
    public <T extends IConnection> IConnectionFactory getByConnection(Class<T> clazz) {
        if (clazz == null) {
            return null;
        }
        IConnectionFactory matchingFactory = null;
        for (IConnectionFactory factory : this.connectionFactories) {
            if (factory == null || !factory.canCreate(clazz)) continue;
            matchingFactory = factory;
            break;
        }
        return matchingFactory;
    }

    @Override
    public Collection<IConnectionFactory> getAll() {
        return new ArrayList<IConnectionFactory>(this.connectionFactories);
    }

    @Override
    public <T extends IConnection> Collection<IConnectionFactory> getAll(Class<T> clazz) {
        return new ArrayList<IConnectionFactory>(this.connectionFactories);
    }
}

