/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.aesh.ui.internal.viewer;

import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;
import org.jboss.tools.aesh.core.console.Console;
import org.jboss.tools.aesh.ui.internal.util.CharacterConstants;
import org.jboss.tools.aesh.ui.internal.util.FontManager;
import org.jboss.tools.aesh.ui.internal.util.StyleRangeHelper;

public class TextWidget
extends StyledText {
    Console console = null;

    public TextWidget(Composite parent, int style) {
        super(parent, style);
        this.initializeFontListener();
    }

    public void setConsole(Console console) {
        this.console = console;
    }

    public void invokeAction(int action) {
        switch (action) {
            case 0x1000008: {
                this.console.sendInput(CharacterConstants.END_LINE);
                break;
            }
            case 0x1000007: {
                this.console.sendInput(CharacterConstants.START_LINE);
                break;
            }
            case 0x1000001: {
                this.console.sendInput(CharacterConstants.PREV_HISTORY);
                break;
            }
            case 0x1000002: {
                this.console.sendInput(CharacterConstants.NEXT_HISTORY);
                break;
            }
            case 0x1000003: {
                this.console.sendInput(CharacterConstants.PREV_CHAR);
                break;
            }
            case 0x1000004: {
                this.console.sendInput(CharacterConstants.NEXT_CHAR);
                break;
            }
            case 8: {
                this.console.sendInput(CharacterConstants.DELETE_PREV_CHAR);
                break;
            }
            case 127: {
                this.console.sendInput(CharacterConstants.DELETE_NEXT_CHAR);
                break;
            }
            default: {
                super.invokeAction(action);
            }
        }
    }

    private void initializeFontListener() {
        FontManager.INSTANCE.addListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                StyleRange[] oldStyleRanges = TextWidget.this.getStyleRanges();
                StyleRange[] newStyleRanges = new StyleRange[oldStyleRanges.length];
                int i = 0;
                while (i < oldStyleRanges.length) {
                    newStyleRanges[i] = StyleRangeHelper.updateStyleRange(oldStyleRanges[i]);
                    ++i;
                }
                TextWidget.this.setStyleRanges(newStyleRanges);
            }
        });
    }
}

