/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.forge.core.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.AbstractMavenConfigurationChangeListener;
import org.eclipse.m2e.core.embedder.IMavenConfiguration;
import org.eclipse.m2e.core.embedder.IMavenConfigurationChangeListener;
import org.eclipse.m2e.core.embedder.MavenConfigurationChangeEvent;
import org.jboss.tools.usage.event.UsageEventType;
import org.jboss.tools.usage.event.UsageReporter;
import org.osgi.framework.BundleContext;

public class ForgeCorePlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.jboss.tools.forge.core";
    private static ForgeCorePlugin plugin;
    private static Thread shutdownHook;
    private static List<IProcess> processes;
    private UsageEventType forgeStartEventType;

    static {
        processes = new ArrayList<IProcess>();
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.setMavenSettings();
        this.initializeShutdownHook();
        plugin = this;
        this.initializeUsageReporting();
    }

    private void initializeUsageReporting() {
        this.forgeStartEventType = new UsageEventType("forge", UsageEventType.getVersion((Plugin)this), null, "start", "Forge Runtime Version", "major.minor.micro.identifier");
        UsageReporter.getInstance().registerEvent(this.forgeStartEventType);
    }

    private void setMavenSettings() {
        IMavenConfiguration mavenConfig = MavenPlugin.getMavenConfiguration();
        mavenConfig.addConfigurationChangeListener((IMavenConfigurationChangeListener)new AbstractMavenConfigurationChangeListener(){

            public void mavenConfigurationChange(MavenConfigurationChangeEvent event) throws CoreException {
                ForgeCorePlugin.this.registerSystemProperties();
            }
        });
        this.registerSystemProperties();
    }

    private void registerSystemProperties() {
        IMavenConfiguration mavenConfig = MavenPlugin.getMavenConfiguration();
        Properties properties = System.getProperties();
        String userSettingsFile = mavenConfig.getUserSettingsFile();
        if (userSettingsFile != null) {
            properties.setProperty("org.apache.maven.user-settings", userSettingsFile);
        } else {
            properties.remove("org.apache.maven.user-settings");
        }
        String globalSettingsFile = mavenConfig.getGlobalSettingsFile();
        if (globalSettingsFile != null) {
            properties.setProperty("org.apache.maven.global-settings", globalSettingsFile);
        } else {
            properties.remove("org.apache.maven.global-settings");
        }
    }

    public UsageEventType getForgeStartEventType() {
        return this.forgeStartEventType;
    }

    private void initializeShutdownHook() {
        if (shutdownHook == null) {
            shutdownHook = new Thread(new Runnable(){

                @Override
                public void run() {
                    for (IProcess process : processes) {
                        if (process == null || !process.canTerminate()) continue;
                        try {
                            process.terminate();
                        }
                        catch (DebugException e) {
                            ForgeCorePlugin.log(e);
                        }
                    }
                }
            });
            Runtime.getRuntime().addShutdownHook(shutdownHook);
        }
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static ForgeCorePlugin getDefault() {
        return plugin;
    }

    public static void log(Throwable t) {
        ForgeCorePlugin.getDefault().getLog().log(ForgeCorePlugin.newErrorStatus("Error logged from Forge Core Plugin: ", t));
    }

    private static IStatus newErrorStatus(String message, Throwable exception) {
        return new Status(4, PLUGIN_ID, 1, message, exception);
    }

    public static void addForgeProcess(IProcess process) {
        processes.add(process);
    }

    public static void removeForgeProcess(IProcess process) {
        processes.remove(process);
    }

    public static void log(IStatus status) {
        ResourcesPlugin.getPlugin().getLog().log(status);
    }

    public static void logErrorMessage(String message) {
        ForgeCorePlugin.log(4, message);
    }

    public static void logInfoMessage(String message) {
        ForgeCorePlugin.log(1, message);
    }

    private static void log(int status, String message) {
        ForgeCorePlugin.log((IStatus)new Status(status, PLUGIN_ID, status, message, null));
    }
}

