/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.pages.xml.model.handlers;

import java.util.Properties;
import org.jboss.tools.common.meta.XAdoptManager;
import org.jboss.tools.common.meta.XModelEntity;
import org.jboss.tools.common.meta.action.impl.handlers.DefaultCreateHandler;
import org.jboss.tools.common.meta.action.impl.handlers.DefaultRemoveHandler;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.util.FindObjectHelper;
import org.jboss.tools.common.model.util.XModelObjectUtil;
import org.jboss.tools.jst.web.model.ReferenceObject;
import org.jboss.tools.seam.pages.xml.model.SeamPagesConstants;
import org.jboss.tools.seam.pages.xml.model.helpers.SeamPagesDiagramStructureHelper;

public class PageAdopt
implements XAdoptManager,
SeamPagesConstants {
    public static boolean move_case = false;

    public boolean isAdoptable(XModelObject target, XModelObject object) {
        String entity = object.getModelEntity().getName();
        if ("SeamPagesDiagramItemOutput".equals(entity)) {
            if (move_case) {
                return this.canMoveCase(target, object);
            }
            return this.canBeOutputTarget(target);
        }
        if ("SeamPagesDiagramItem".equals(entity)) {
            return this.canDrawCustomLink(target, object) || this.canBeOutputTarget(target);
        }
        if (entity.startsWith("SeamPage")) {
            return this.canBeOutputTarget(target);
        }
        return false;
    }

    private boolean canBeOutputTarget(XModelObject group) {
        String type = group.getAttributeValue("type");
        if ("exception".equals(type)) {
            return false;
        }
        String path = group.getAttributeValue("path");
        if (path == null) {
            path = group.getAttributeValue("view id");
        }
        if (path == null) {
            return false;
        }
        return path.length() != 0 && path.indexOf("*") < 0;
    }

    private boolean canDrawCustomLink(XModelObject target, XModelObject source) {
        if (!(source instanceof ReferenceObject)) {
            return false;
        }
        ReferenceObject i = (ReferenceObject)source;
        if (i.getReference() != null) {
            return false;
        }
        String sourcePath = source.getAttributeValue("path");
        if (!PageAdopt.isEL(sourcePath)) {
            return false;
        }
        if (!(target instanceof ReferenceObject)) {
            return false;
        }
        ReferenceObject j = (ReferenceObject)target;
        if (j.getReference() == null) {
            return false;
        }
        String type = target.getAttributeValue("type");
        if ("exception".equals(type)) {
            return false;
        }
        String path = target.getAttributeValue("path");
        if (path == null) {
            path = target.getAttributeValue("view id");
        }
        return path != null;
    }

    public static boolean isEL(String path) {
        return path.indexOf(123) >= 0;
    }

    private boolean canMoveCase(XModelObject target, XModelObject object) {
        XModelObject case_ = null;
        case_ = object instanceof ReferenceObject ? ((ReferenceObject)object).getReference() : object;
        XModelObject rule = null;
        rule = target instanceof ReferenceObject ? ((ReferenceObject)target).getReference() : target;
        if (case_ == null || case_.getParent().getModelEntity().getName().startsWith("SeamPageException")) {
            return false;
        }
        return rule == null || !case_.getPath().startsWith(rule.getPath());
    }

    public void adopt(XModelObject target, XModelObject object, Properties p) throws XModelException {
        String entity = object.getModelEntity().getName();
        if ("SeamPagesDiagramItemOutput".equals(entity)) {
            if (move_case) {
                this.moveOutput(object, target, p);
            } else {
                this.adoptOutput(object, target, p);
            }
        } else if ("SeamPagesDiagramItem".equals(entity)) {
            if (this.canDrawCustomLink(target, object)) {
                this.drawCustomLink(target, object);
            } else {
                this.adoptItem(object, target, p);
            }
        } else if (entity.startsWith("SeamPage")) {
            this.adoptSeamPage(object, target, p);
        }
    }

    protected void adoptOutput(XModelObject source, XModelObject target, Properties p) throws XModelException {
        ReferenceObject i = (ReferenceObject)source;
        this.adoptCase(i.getReference(), target, p);
    }

    protected void adoptCase(XModelObject source, XModelObject target, Properties p) throws XModelException {
        source.getModel().changeObjectAttribute(source, "view id", target.getAttributeValue("path"));
    }

    protected void adoptItem(XModelObject source, XModelObject target, Properties p) throws XModelException {
        ReferenceObject i = (ReferenceObject)source;
        if (i.getReference() == null) {
            String path = i.getAttributeValue("path");
            if (PageAdopt.isEL(path)) {
                return;
            }
            XModelObject rule = this.createRule(target, path);
            this.adoptSeamPage(rule, target, p);
        } else {
            this.adoptSeamPage(i.getReference(), target, p);
        }
    }

    protected void adoptSeamPage(XModelObject source, XModelObject target, Properties p) throws XModelException {
        XModelObject redirect;
        String path = target.getAttributeValue("path");
        if (source != null && source.getModelEntity().getName().startsWith("SeamPageException") && (redirect = source.getChildByPath("target")) != null) {
            redirect.getModel().editObjectAttribute(redirect, "view id", path);
            return;
        }
        XModelObject cs = source.getModel().createModelObject(XModelObjectUtil.getVersionedChildEntity((XModelEntity)source.getModelEntity(), (String)"SeamPageNavigationRule"), null);
        XModelObject redirect2 = source.getModel().createModelObject(XModelObjectUtil.getVersionedChildEntity((XModelEntity)cs.getModelEntity(), (String)"SeamPageRedirect"), null);
        redirect2.setAttributeValue("view id", path);
        cs.addChild(redirect2);
        DefaultCreateHandler.addCreatedObject((XModelObject)source, (XModelObject)cs, (Properties)p);
    }

    void moveOutput(XModelObject source, XModelObject target, Properties p) throws XModelException {
        ReferenceObject i = (ReferenceObject)source;
        this.moveCase(i.getReference(), target, p);
    }

    void moveCase(XModelObject source, XModelObject target, Properties p) throws XModelException {
        XModelObject rule = null;
        if (target instanceof ReferenceObject) {
            rule = ((ReferenceObject)target).getReference();
            if (rule == null) {
                String path = target.getAttributeValue("path");
                rule = this.createRule(target, path);
            }
        } else {
            rule = target;
        }
        if (rule == null || source.getParent() == rule) {
            return;
        }
        if ((source = source.getParent()).getModelEntity().getName().startsWith("SeamPageRule")) {
            source = source.getParent();
        }
        DefaultRemoveHandler.removeFromParent((XModelObject)source);
        DefaultCreateHandler.addCreatedObject((XModelObject)rule, (XModelObject)source, (Properties)p);
    }

    XModelObject createRule(XModelObject o, String path) throws XModelException {
        XModelObject file = SeamPagesDiagramStructureHelper.instance.getParentFile(o);
        XModelObject pages = file.getChildByPath("Pages");
        String childEntity = pages.getModelEntity().getChildren()[0].getName();
        XModelObject rule = pages.getModel().createModelObject(childEntity, null);
        rule.setAttributeValue("view id", path);
        DefaultCreateHandler.addCreatedObject((XModelObject)pages, (XModelObject)rule, (int)FindObjectHelper.IN_EDITOR_ONLY);
        return rule;
    }

    void drawCustomLink(XModelObject target, XModelObject source) throws XModelException {
        ReferenceObject j = (ReferenceObject)target;
        String viewId = j.getReference().getAttributeValue("view id");
        XModelObject output = target.getModel().createModelObject("SeamPagesDiagramItemOutput", null);
        output.setAttributeValue("id", viewId);
        output.setAttributeValue("path", viewId);
        String name = XModelObjectUtil.createNewChildName((String)"output", (XModelObject)source);
        output.setAttributeValue("name", name);
        output.setAttributeValue("subtype", "custom");
        output.setAttributeValue("target", target.getPathPart());
        DefaultCreateHandler.addCreatedObject((XModelObject)source, (XModelObject)output, (int)FindObjectHelper.IN_EDITOR_ONLY);
    }
}

