/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.ui.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.xml.namespace.QName;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.Dispatch;
import javax.xml.ws.Response;
import javax.xml.ws.Service;
import org.apache.axis.message.SOAPEnvelope;
import org.eclipse.core.runtime.IProgressMonitor;
import org.jboss.tools.ws.ui.messages.JBossWSUIMessages;
import org.jboss.tools.ws.ui.utils.TesterWSDLUtils;

public class JAXWSTester2 {
    private String resultBody;
    private SOAPEnvelope resultSOAP;
    private SOAPBody resultSOAPBody;
    private Map<String, String> resultHeaders;
    private static final String EMPTY_STRING = "";

    public String getResultBody() {
        return this.resultBody;
    }

    public SOAPBody getResultSOAPBody() {
        return this.resultSOAPBody;
    }

    public Map<String, String> getResultHeaders() {
        return this.resultHeaders;
    }

    public SOAPEnvelope getResultSOAP() {
        return this.resultSOAP;
    }

    public void doTest(IProgressMonitor monitor, String endpointurl, String actionurl, String ns, String serviceName, String messageName, String body) throws Exception {
        this.doTest(monitor, endpointurl, actionurl, ns, serviceName, messageName, body, null, null);
    }

    public void doTest(IProgressMonitor monitor, String endpointurl, String actionurl, String ns, String serviceName, String messageName, String body, String uid, String pwd) throws Exception {
        block11: {
            this.resultBody = EMPTY_STRING;
            if (endpointurl.toLowerCase().startsWith("https://")) {
                X509TrustManager t = new X509TrustManager(){

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return new X509Certificate[0];
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                    }

                    @Override
                    public void checkClientTrusted(X509Certificate[] arg0, String arg1) {
                    }
                };
                TrustManager[] tm = new TrustManager[]{t};
                SSLContext ctx = SSLContext.getInstance("SSL");
                ctx.init(null, tm, new SecureRandom());
                HttpsURLConnection.setDefaultSSLSocketFactory(ctx.getSocketFactory());
                HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

                    @Override
                    public boolean verify(String hostname, SSLSession session) {
                        return true;
                    }
                });
            }
            URL serviceURL = new URL(endpointurl);
            QName serviceQName = new QName(ns, serviceName);
            Service s = Service.create((URL)serviceURL, (QName)serviceQName);
            boolean isSOAP12 = TesterWSDLUtils.isRequestBodySOAP12(body);
            QName messageQName = new QName(ns, messageName);
            Dispatch d = s.createDispatch(messageQName, SOAPMessage.class, Service.Mode.MESSAGE);
            MessageFactory mf = MessageFactory.newInstance();
            if (isSOAP12) {
                mf = MessageFactory.newInstance((String)"SOAP 1.2 Protocol");
            } else if (actionurl != null && !actionurl.trim().isEmpty()) {
                d.getRequestContext().put("javax.xml.ws.soap.http.soapaction.use", true);
                d.getRequestContext().put("javax.xml.ws.soap.http.soapaction.uri", actionurl);
            }
            if (uid != null && pwd != null) {
                d.getRequestContext().put("javax.xml.ws.security.auth.username", uid);
                d.getRequestContext().put("javax.xml.ws.security.auth.password", pwd);
            }
            SOAPMessage m = mf.createMessage(null, (InputStream)new ByteArrayInputStream(body.getBytes()));
            m.saveChanges();
            Response response = d.invokeAsync((Object)m);
            while (!response.isDone()) {
                if (monitor == null || !monitor.isCanceled()) continue;
                response.cancel(true);
            }
            try {
                if (!response.isCancelled()) {
                    Object responseHeaders;
                    SOAPMessage o = (SOAPMessage)response.get();
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    o.writeTo((OutputStream)baos);
                    this.resultBody = baos.toString();
                    this.resultSOAPBody = o.getSOAPBody();
                    if (response.getContext() != null && (responseHeaders = response.getContext().get("javax.xml.ws.http.response.headers")) != null && responseHeaders instanceof Map) {
                        this.resultHeaders = (Map)responseHeaders;
                    }
                    break block11;
                }
                throw new InterruptedException(JBossWSUIMessages.JAXRSWSTestView_Message_Service_Invocation_Cancelled);
            }
            catch (ExecutionException ex) {
                Throwable cause = ex.getCause();
                throw new Exception(cause);
            }
            catch (InterruptedException ie) {
                throw ie;
            }
        }
    }
}

