/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.jpt.core.internal.resource.java;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.common.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ElementIndexedAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.NestedIndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ShortCircuitAnnotationElementAdapter;
import org.eclipse.jpt.common.core.resource.java.JavaResourceModel;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.IndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.jboss.tools.hibernate.jpt.core.internal.resource.java.ParameterAnnotation;

public class SourceParameterAnnotation
extends SourceAnnotation
implements ParameterAnnotation {
    private final DeclarationAnnotationElementAdapter<String> nameDeclarationAdapter;
    private final AnnotationElementAdapter<String> nameAdapter;
    private String name;
    private final DeclarationAnnotationElementAdapter<String> valueDeclarationAdapter;
    private final AnnotationElementAdapter<String> valueAdapter;
    private String value;
    private CompilationUnit astRoot;

    public SourceParameterAnnotation(JavaResourceModel parent, AnnotatedElement member, IndexedDeclarationAnnotationAdapter idaa) {
        super(parent, member, (DeclarationAnnotationAdapter)idaa, (AnnotationAdapter)new ElementIndexedAnnotationAdapter(member, idaa));
        this.nameDeclarationAdapter = this.buildNameAdapter((DeclarationAnnotationAdapter)idaa);
        this.nameAdapter = this.buildAdapter(this.nameDeclarationAdapter);
        this.valueDeclarationAdapter = this.buildValueAdapter((DeclarationAnnotationAdapter)idaa);
        this.valueAdapter = this.buildAdapter(this.valueDeclarationAdapter);
    }

    public String getAnnotationName() {
        return "org.hibernate.annotations.Parameter";
    }

    private AnnotationElementAdapter<String> buildAdapter(DeclarationAnnotationElementAdapter<String> daea) {
        return new ShortCircuitAnnotationElementAdapter(this.annotatedElement, daea);
    }

    private DeclarationAnnotationElementAdapter<String> buildNameAdapter(DeclarationAnnotationAdapter adapter) {
        return ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)adapter, (String)"name");
    }

    private DeclarationAnnotationElementAdapter<String> buildValueAdapter(DeclarationAnnotationAdapter adapter) {
        return ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)adapter, (String)"value");
    }

    public void initialize(CompilationUnit astRoot) {
        this.astRoot = astRoot;
        this.name = this.buildName(astRoot);
        this.value = this.buildValue(astRoot);
    }

    public void synchronizeWith(CompilationUnit astRoot) {
        this.astRoot = astRoot;
        this.syncName(this.buildName(astRoot));
        this.syncValue(this.buildValue(astRoot));
    }

    public void toString(StringBuilder sb) {
        sb.append(this.name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        if (ObjectTools.notEquals((Object)this.name, (Object)name)) {
            this.name = name;
            this.nameAdapter.setValue((Object)name);
        }
    }

    private void syncName(String astName) {
        String old = this.name;
        this.name = astName;
        this.firePropertyChanged("name", old, astName);
    }

    private String buildName(CompilationUnit astRoot) {
        return (String)this.nameAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getNameTextRange() {
        return this.getElementTextRange(this.nameDeclarationAdapter, this.getAstAnnotation(this.astRoot));
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String value) {
        if (ObjectTools.notEquals((Object)this.value, (Object)value)) {
            this.value = value;
            this.valueAdapter.setValue((Object)value);
        }
    }

    private void syncValue(String value) {
        String old = this.value;
        this.value = value;
        this.firePropertyChanged("value", old, value);
    }

    private String buildValue(CompilationUnit astRoot) {
        return (String)this.valueAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getValueTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.valueDeclarationAdapter, this.getAstAnnotation(astRoot));
    }

    public static SourceParameterAnnotation createParameter(JavaResourceModel parent, AnnotatedElement member, DeclarationAnnotationAdapter annotationAdapter, String elementName, int index) {
        return new SourceParameterAnnotation(parent, member, SourceParameterAnnotation.buildParameterAnnotationAdapter(annotationAdapter, elementName, index));
    }

    private static IndexedDeclarationAnnotationAdapter buildParameterAnnotationAdapter(DeclarationAnnotationAdapter annotationAdapter, String elementName, int index) {
        return new NestedIndexedDeclarationAnnotationAdapter(annotationAdapter, elementName, index, "org.hibernate.annotations.Parameter");
    }
}

