/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.jpt.core.internal.resource.java;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.common.core.internal.resource.java.source.SourceModel;
import org.eclipse.jpt.common.core.internal.utility.jdt.CombinationIndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ElementIndexedAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ShortCircuitAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceModel;
import org.eclipse.jpt.common.core.resource.java.NestableAnnotation;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.IndexedAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.IndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.iterable.ListIterable;
import org.jboss.tools.hibernate.jpt.core.internal.resource.java.GenericGeneratorAnnotation;
import org.jboss.tools.hibernate.jpt.core.internal.resource.java.ParameterAnnotation;
import org.jboss.tools.hibernate.jpt.core.internal.resource.java.SourceParameterAnnotation;

public class GenericGeneratorAnnotationImpl
extends SourceAnnotation
implements GenericGeneratorAnnotation {
    private static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("org.hibernate.annotations.GenericGenerator");
    private static final DeclarationAnnotationAdapter CONTAINER_DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("org.hibernate.annotations.GenericGenerators");
    private DeclarationAnnotationElementAdapter<String> nameDeclarationAdapter;
    private AnnotationElementAdapter<String> nameAdapter;
    private String name;
    private TextRange nameTextRange;
    private DeclarationAnnotationElementAdapter<String> strategyDeclarationAdapter;
    private AnnotationElementAdapter<String> strategyAdapter;
    private String strategy;
    private TextRange strategyTextRange;
    final ParametersAnnotationContainer parametersContainer = new ParametersAnnotationContainer();

    public GenericGeneratorAnnotationImpl(JavaResourceModel parent, AnnotatedElement member, DeclarationAnnotationAdapter daa, AnnotationAdapter annotationAdapter) {
        super(parent, member, daa, annotationAdapter);
        this.nameDeclarationAdapter = this.buildNameDeclarationAdapter();
        this.nameAdapter = this.buildNameAdapter();
        this.strategyDeclarationAdapter = this.buildStrategyDeclarationAdapter();
        this.strategyAdapter = this.buildStrategyAdapter();
    }

    public void initialize(CompilationUnit astRoot) {
        this.name = this.buildName(astRoot);
        this.nameTextRange = this.buildNameTextRange(astRoot);
        this.strategy = this.buildStrategy(astRoot);
        this.strategyTextRange = this.buildStrategyTextRange(astRoot);
        this.parametersContainer.initializeFromContainerAnnotation(this.getAstAnnotation(astRoot));
    }

    public void synchronizeWith(CompilationUnit astRoot) {
        this.syncName(this.buildName(astRoot));
        this.nameTextRange = this.buildNameTextRange(astRoot);
        this.syncStrategy(this.buildStrategy(astRoot));
        this.strategyTextRange = this.buildStrategyTextRange(astRoot);
        this.parametersContainer.synchronize(this.getAstAnnotation(astRoot));
    }

    public String getAnnotationName() {
        return "org.hibernate.annotations.GenericGenerator";
    }

    @Override
    public String getStrategy() {
        return this.strategy;
    }

    @Override
    public void setStrategy(String newStrategy) {
        if (ObjectTools.notEquals((Object)this.strategy, (Object)newStrategy)) {
            this.strategy = newStrategy;
            this.strategyAdapter.setValue((Object)newStrategy);
        }
    }

    private void syncStrategy(String strategy) {
        String old = this.strategy;
        this.strategy = strategy;
        this.firePropertyChanged("strategyProperty", old, strategy);
    }

    protected String buildStrategy(CompilationUnit astRoot) {
        return (String)this.strategyAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getStrategyTextRange() {
        return this.strategyTextRange;
    }

    private TextRange buildStrategyTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.strategyDeclarationAdapter, this.getAstAnnotation(astRoot));
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (ObjectTools.notEquals((Object)this.name, (Object)name)) {
            this.name = name;
            this.nameAdapter.setValue((Object)name);
        }
    }

    private void syncName(String astName) {
        String old = this.name;
        this.name = astName;
        this.firePropertyChanged("name", old, astName);
    }

    protected String buildName(CompilationUnit astRoot) {
        return (String)this.nameAdapter.getValue(astRoot);
    }

    public TextRange getNameTextRange() {
        return this.nameTextRange;
    }

    private TextRange buildNameTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.nameDeclarationAdapter, this.getAstAnnotation(astRoot));
    }

    public Integer getAllocationSize() {
        return null;
    }

    public TextRange getAllocationSizeTextRange() {
        return null;
    }

    public Integer getInitialValue() {
        return null;
    }

    public TextRange getInitialValueTextRange() {
        return null;
    }

    public void setAllocationSize(Integer allocationSize) {
        throw new UnsupportedOperationException();
    }

    public void setInitialValue(Integer initialValue) {
        throw new UnsupportedOperationException();
    }

    protected ShortCircuitAnnotationElementAdapter<String> buildNameAdapter() {
        return new ShortCircuitAnnotationElementAdapter(this.annotatedElement, this.nameDeclarationAdapter);
    }

    protected ShortCircuitAnnotationElementAdapter<String> buildStrategyAdapter() {
        return new ShortCircuitAnnotationElementAdapter(this.annotatedElement, this.strategyDeclarationAdapter);
    }

    @Override
    public ListIterable<ParameterAnnotation> getParameters() {
        return this.parametersContainer.getNestedAnnotations();
    }

    @Override
    public int getParametersSize() {
        return this.parametersContainer.getNestedAnnotationsSize();
    }

    @Override
    public ParameterAnnotation parameterAt(int index) {
        return (ParameterAnnotation)this.parametersContainer.getNestedAnnotation(index);
    }

    @Override
    public ParameterAnnotation addParameter(int index) {
        return (ParameterAnnotation)this.parametersContainer.addNestedAnnotation(index);
    }

    @Override
    public void moveParameter(int targetIndex, int sourceIndex) {
        this.parametersContainer.moveNestedAnnotation(targetIndex, sourceIndex);
    }

    @Override
    public void removeParameter(int index) {
        this.parametersContainer.removeNestedAnnotation(index);
    }

    ParameterAnnotation buildParameter(int index) {
        return SourceParameterAnnotation.createParameter((JavaResourceModel)this, this.annotatedElement, this.daa, "parameters", index);
    }

    public boolean isUnset() {
        return super.isUnset() && this.name == null && this.strategy == null && this.parametersContainer.isEmpty();
    }

    public void toString(StringBuilder sb) {
        super.toString(sb);
        sb.append(this.name);
    }

    private DeclarationAnnotationElementAdapter<String> buildNameDeclarationAdapter() {
        return ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)this.daa, (String)"name");
    }

    private DeclarationAnnotationElementAdapter<String> buildStrategyDeclarationAdapter() {
        return ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)this.daa, (String)"strategy");
    }

    public static NestableAnnotation buildGenericGeneratorAnnotation(JavaResourceAnnotatedElement parent, AnnotatedElement annotatedElement, int index) {
        IndexedDeclarationAnnotationAdapter idaa = GenericGeneratorAnnotationImpl.buildGnericGeneratorDeclarationAnnotationAdapter(index);
        IndexedAnnotationAdapter iaa = GenericGeneratorAnnotationImpl.buildGenericGeneratorAnnotationAdapter(annotatedElement, idaa);
        return new GenericGeneratorAnnotationImpl((JavaResourceModel)parent, annotatedElement, (DeclarationAnnotationAdapter)idaa, (AnnotationAdapter)iaa);
    }

    protected static IndexedAnnotationAdapter buildGenericGeneratorAnnotationAdapter(AnnotatedElement annotatedElement, IndexedDeclarationAnnotationAdapter idaa) {
        return new ElementIndexedAnnotationAdapter(annotatedElement, idaa);
    }

    private static IndexedDeclarationAnnotationAdapter buildGnericGeneratorDeclarationAnnotationAdapter(int index) {
        CombinationIndexedDeclarationAnnotationAdapter idaa = new CombinationIndexedDeclarationAnnotationAdapter(DECLARATION_ANNOTATION_ADAPTER, CONTAINER_DECLARATION_ANNOTATION_ADAPTER, index, "org.hibernate.annotations.GenericGenerator");
        return idaa;
    }

    class ParametersAnnotationContainer
    extends SourceModel.AnnotationContainer<ParameterAnnotation> {
        ParametersAnnotationContainer() {
            super((SourceModel)GenericGeneratorAnnotationImpl.this);
        }

        protected String getNestedAnnotationsListName() {
            return "parameters";
        }

        protected String getElementName() {
            return "parameters";
        }

        public String getNestedAnnotationName() {
            return "org.hibernate.annotations.Parameter";
        }

        protected ParameterAnnotation buildNestedAnnotation(int index) {
            return GenericGeneratorAnnotationImpl.this.buildParameter(index);
        }
    }
}

