/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.jpt.core.internal.context.java;

import java.util.List;
import org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedPersistentAttribute;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaIdMapping;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.jboss.tools.hibernate.jpt.core.internal.HibernateAbstractJpaFactory;
import org.jboss.tools.hibernate.jpt.core.internal.context.java.HibernateGenericGeneratorContainer;
import org.jboss.tools.hibernate.jpt.core.internal.context.java.HibernateJavaColumn;
import org.jboss.tools.hibernate.jpt.core.internal.context.java.HibernateJavaIdMapping;
import org.jboss.tools.hibernate.jpt.core.internal.context.java.JavaIndex;
import org.jboss.tools.hibernate.jpt.core.internal.context.java.JavaType;
import org.jboss.tools.hibernate.jpt.core.internal.resource.java.IndexAnnotation;
import org.jboss.tools.hibernate.jpt.core.internal.resource.java.TypeAnnotation;

public class HibernateJavaIdMappingImpl
extends AbstractJavaIdMapping
implements HibernateJavaIdMapping {
    protected JavaIndex index = this.buildIndex();
    protected JavaType type = this.buildType();

    public HibernateJavaIdMappingImpl(JavaSpecifiedPersistentAttribute parent) {
        super(parent);
    }

    @Override
    public HibernateGenericGeneratorContainer getGeneratorContainer() {
        return (HibernateGenericGeneratorContainer)super.getGeneratorContainer();
    }

    protected HibernateAbstractJpaFactory getJpaFactory() {
        return (HibernateAbstractJpaFactory)super.getJpaFactory();
    }

    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.syncIndex();
        this.syncType();
    }

    public void update() {
        super.update();
        if (this.index != null) {
            this.index.update();
        }
        if (this.type != null) {
            this.type.update();
        }
    }

    public HibernateJavaColumn getColumn() {
        return (HibernateJavaColumn)this.column;
    }

    public String getPrimaryKeyColumnName() {
        return this.getColumn().getDBColumnName();
    }

    @Override
    public JavaIndex getIndex() {
        return this.index;
    }

    @Override
    public JavaIndex addIndex() {
        if (this.getIndex() != null) {
            throw new IllegalStateException("index already exists");
        }
        IndexAnnotation annotation = this.buildIndexAnnotation();
        JavaIndex index = this.buildIndex(annotation);
        this.setIndex(index);
        return index;
    }

    protected IndexAnnotation buildIndexAnnotation() {
        return (IndexAnnotation)this.getResourceAttribute().addAnnotation("org.hibernate.annotations.Index");
    }

    @Override
    public void removeIndex() {
        if (this.getIndex() == null) {
            throw new IllegalStateException("index does not exist, cannot be removed");
        }
        this.getResourceAttribute().removeAnnotation("org.hibernate.annotations.Index");
        this.setIndex(null);
    }

    protected JavaIndex buildIndex() {
        IndexAnnotation annotation = this.getIndexAnnotation();
        return annotation == null ? null : this.buildIndex(annotation);
    }

    protected IndexAnnotation getIndexAnnotation() {
        return (IndexAnnotation)this.getResourceAttribute().getAnnotation("org.hibernate.annotations.Index");
    }

    protected JavaIndex buildIndex(IndexAnnotation annotation) {
        return this.getJpaFactory().buildIndex(this, annotation);
    }

    protected void syncIndex() {
        IndexAnnotation annotation = this.getIndexAnnotation();
        if (annotation == null) {
            if (this.getIndex() != null) {
                this.setIndex(null);
            }
        } else if (this.getIndex() != null && this.getIndex().getIndexAnnotation() == annotation) {
            this.index.synchronizeWithResourceModel();
        } else {
            this.setIndex(this.buildIndex(annotation));
        }
    }

    protected void setIndex(JavaIndex newIndex) {
        JavaIndex oldIndex = this.index;
        this.index = newIndex;
        this.firePropertyChanged("index", oldIndex, newIndex);
    }

    @Override
    public JavaType getType() {
        return this.type;
    }

    @Override
    public JavaType addType() {
        if (this.type != null) {
            throw new IllegalStateException("type already exists: " + this.type);
        }
        TypeAnnotation annotation = this.buildTypeAnnotation();
        JavaType value = this.buildType(annotation);
        this.setType(value);
        return value;
    }

    protected TypeAnnotation buildTypeAnnotation() {
        return (TypeAnnotation)this.getResourceAttribute().addAnnotation("org.hibernate.annotations.Type");
    }

    @Override
    public void removeType() {
        if (this.type == null) {
            throw new IllegalStateException("generated value does not exist");
        }
        this.getResourceAttribute().removeAnnotation("org.hibernate.annotations.Type");
        this.setType(null);
    }

    protected JavaType buildType() {
        TypeAnnotation annotation = this.getTypeAnnotation();
        return annotation == null ? null : this.buildType(annotation);
    }

    protected TypeAnnotation getTypeAnnotation() {
        return (TypeAnnotation)this.getResourceAttribute().getAnnotation("org.hibernate.annotations.Type");
    }

    protected JavaType buildType(TypeAnnotation generatedValueAnnotation) {
        return this.getJpaFactory().buildType(this, generatedValueAnnotation);
    }

    protected void syncType() {
        TypeAnnotation annotation = this.getTypeAnnotation();
        if (annotation == null) {
            if (this.type != null) {
                this.setType(null);
            }
        } else if (this.type != null && this.type.getTypeAnnotation() == annotation) {
            this.type.synchronizeWithResourceModel();
        } else {
            this.setType(this.buildType(annotation));
        }
    }

    protected void setType(JavaType value) {
        JavaType old = this.type;
        this.type = value;
        this.firePropertyChanged("type", old, value);
    }

    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        if (this.index != null) {
            this.index.validate(messages, reporter);
        }
        if (this.type != null) {
            this.type.validate(messages, reporter);
        }
    }
}

