/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.jpt.core.internal.context.java;

import java.util.List;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.iterable.FilteringIterable;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterable.TransformationIterable;
import org.eclipse.jpt.common.utility.internal.predicate.PredicateTools;
import org.eclipse.jpt.common.utility.transformer.Transformer;
import org.eclipse.jpt.jpa.core.JpaModel;
import org.eclipse.jpt.jpa.core.context.BaseJoinColumn;
import org.eclipse.jpt.jpa.core.context.Entity;
import org.eclipse.jpt.jpa.core.context.JpaContextModel;
import org.eclipse.jpt.jpa.core.context.NamedColumn;
import org.eclipse.jpt.jpa.core.context.Table;
import org.eclipse.jpt.jpa.core.context.TypeMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaEntity;
import org.eclipse.jpt.jpa.core.internal.jpa2.context.java.NullJavaCacheable2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.Cacheable2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.CacheableReference2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.java.JavaCacheableReference2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.persistence.PersistenceUnit2_0;
import org.eclipse.jpt.jpa.core.resource.java.EntityAnnotation;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.jboss.tools.hibernate.jpt.core.internal.HibernateAbstractJpaFactory;
import org.jboss.tools.hibernate.jpt.core.internal.HibernateJpaProject;
import org.jboss.tools.hibernate.jpt.core.internal.HibernateJptPlugin;
import org.jboss.tools.hibernate.jpt.core.internal.context.HibernateTable;
import org.jboss.tools.hibernate.jpt.core.internal.context.java.HibernateGenericGeneratorContainer;
import org.jboss.tools.hibernate.jpt.core.internal.context.java.HibernateJavaEntity;
import org.jboss.tools.hibernate.jpt.core.internal.context.java.HibernateJavaTable;
import org.jboss.tools.hibernate.jpt.core.internal.context.java.HibernateJavaTypeDefContainer;
import org.jboss.tools.hibernate.jpt.core.internal.context.java.JavaDiscriminatorFormula;
import org.jboss.tools.hibernate.jpt.core.internal.resource.java.DiscriminatorFormulaAnnotation;
import org.jboss.tools.hibernate.jpt.core.internal.validation.HibernateJpaValidationMessage;
import org.jboss.tools.hibernate.runtime.spi.INamingStrategy;

public class HibernateJavaEntityImpl
extends AbstractJavaEntity
implements HibernateJavaEntity {
    protected final HibernateJavaTypeDefContainer typeDefContainer;
    protected JavaDiscriminatorFormula discriminatorFormula = this.buildDiscriminatorFormula();
    protected final Cacheable2_0 cacheable;

    public HibernateJavaEntityImpl(JavaPersistentType parent, EntityAnnotation mappingAnnotation) {
        super(parent, mappingAnnotation);
        this.typeDefContainer = this.getJpaFactory().buildJavaTypeDefContainer((JpaContextModel)parent, (JavaResourceAnnotatedElement)this.getJavaResourceType());
        this.cacheable = this.buildJavaCachable();
    }

    protected Cacheable2_0 buildJavaCachable() {
        return this.isJpa2_0Compatible() ? this.getJpaFactory2_0().buildJavaCacheable((JavaCacheableReference2_0)this) : new NullJavaCacheable2_0((JavaCacheableReference2_0)this);
    }

    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.cacheable.synchronizeWithResourceModel();
        this.typeDefContainer.synchronizeWithResourceModel();
        this.syncDiscriminatorFormula();
    }

    public void update() {
        super.update();
        this.cacheable.update();
        this.typeDefContainer.update();
        if (this.discriminatorFormula != null) {
            this.discriminatorFormula.update();
        }
    }

    protected HibernateAbstractJpaFactory getJpaFactory() {
        return (HibernateAbstractJpaFactory)this.getJpaPlatform().getJpaFactory();
    }

    public HibernateJpaProject getJpaProject() {
        return (HibernateJpaProject)super.getJpaProject();
    }

    @Override
    public HibernateJavaTypeDefContainer getTypeDefContainer() {
        return this.typeDefContainer;
    }

    @Override
    public HibernateJavaTable getTable() {
        return (HibernateJavaTable)super.getTable();
    }

    @Override
    public JavaDiscriminatorFormula getDiscriminatorFormula() {
        return this.discriminatorFormula;
    }

    @Override
    public JavaDiscriminatorFormula addDiscriminatorFormula() {
        if (this.getDiscriminatorFormula() != null) {
            throw new IllegalStateException("discriminatorFormula already exists");
        }
        DiscriminatorFormulaAnnotation annotation = this.buildDiscriminatorFormulaAnnotation();
        JavaDiscriminatorFormula discriminatorFormula = this.buildDiscriminatorFormula(annotation);
        this.setDiscriminatorFormula(discriminatorFormula);
        return discriminatorFormula;
    }

    protected DiscriminatorFormulaAnnotation buildDiscriminatorFormulaAnnotation() {
        return (DiscriminatorFormulaAnnotation)this.getJavaResourceType().addAnnotation("org.hibernate.annotations.DiscriminatorFormula");
    }

    @Override
    public void removeDiscriminatorFormula() {
        if (this.getDiscriminatorFormula() == null) {
            throw new IllegalStateException("discriminatorFormula does not exist, cannot be removed");
        }
        this.getJavaResourceType().removeAnnotation("org.hibernate.annotations.DiscriminatorFormula");
        this.setDiscriminatorFormula(null);
    }

    protected JavaDiscriminatorFormula buildDiscriminatorFormula() {
        DiscriminatorFormulaAnnotation annotation = this.getDiscriminatorFormulaAnnotation();
        return annotation == null ? null : this.buildDiscriminatorFormula(annotation);
    }

    public DiscriminatorFormulaAnnotation getDiscriminatorFormulaAnnotation() {
        return (DiscriminatorFormulaAnnotation)this.getJavaResourceType().getAnnotation("org.hibernate.annotations.DiscriminatorFormula");
    }

    protected JavaDiscriminatorFormula buildDiscriminatorFormula(DiscriminatorFormulaAnnotation annotation) {
        return this.getJpaFactory().buildJavaDiscriminatorFormula(this, annotation);
    }

    protected void syncDiscriminatorFormula() {
        DiscriminatorFormulaAnnotation annotation = this.getDiscriminatorFormulaAnnotation();
        if (annotation == null) {
            if (this.getDiscriminatorFormula() != null) {
                this.setDiscriminatorFormula(null);
            }
        } else if (this.getDiscriminatorFormula() != null && this.getDiscriminatorFormula().getDiscriminatorFormulaAnnotation() == annotation) {
            this.discriminatorFormula.synchronizeWithResourceModel();
        } else {
            this.setDiscriminatorFormula(this.buildDiscriminatorFormula(annotation));
        }
    }

    protected void setDiscriminatorFormula(JavaDiscriminatorFormula newDiscriminatorFormula) {
        JavaDiscriminatorFormula oldDiscriminatorFormula = this.discriminatorFormula;
        this.discriminatorFormula = newDiscriminatorFormula;
        this.firePropertyChanged("discriminatorFormula", oldDiscriminatorFormula, newDiscriminatorFormula);
    }

    @Override
    public HibernateGenericGeneratorContainer getGeneratorContainer() {
        return (HibernateGenericGeneratorContainer)super.getGeneratorContainer();
    }

    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.getTypeDefContainer().validate(messages, reporter);
    }

    protected AbstractJavaEntity.PrimaryKeyJoinColumnParentAdapter buildPrimaryKeyJoinColumnParentAdapter() {
        return new HibernatePrimaryKeyJoinColumnOwner();
    }

    protected boolean tableNameIsValid(String tableName) {
        return this.tableIsUndefined || IterableTools.contains(this.getAllAssociatedDBTableNames(), (Object)tableName);
    }

    public Iterable<String> getAllAssociatedDBTableNames() {
        return this.convertToDBNames(this.getAllAssociatedTables());
    }

    protected Iterable<String> convertToDBNames(Iterable<Table> tables) {
        return new FilteringIterable(this.convertToDBNames_(tables), PredicateTools.isNotNull());
    }

    protected Iterable<String> convertToDBNames_(Iterable<Table> tables) {
        return new TransformationIterable(tables, (Transformer)new Transformer<Table, String>(){

            public String transform(Table t) {
                if (t instanceof HibernateTable) {
                    return ((HibernateTable)t).getDBTableName();
                }
                return t.getName();
            }
        });
    }

    public String getPrimaryTableName() {
        return this.getTable().getDBTableName();
    }

    public Cacheable2_0 getCacheable() {
        return this.cacheable;
    }

    protected Cacheable2_0 buildCacheable() {
        return this.isJpa2_0Compatible() ? this.getJpaFactory2_0().buildJavaCacheable((JavaCacheableReference2_0)this) : new NullJavaCacheable2_0((JavaCacheableReference2_0)this);
    }

    public boolean calculateDefaultCacheable() {
        Cacheable2_0 parentCacheable = this.getParentCacheable();
        return parentCacheable != null ? parentCacheable.isCacheable() : ((PersistenceUnit2_0)this.getPersistenceUnit()).calculateDefaultCacheable();
    }

    protected Cacheable2_0 getParentCacheable() {
        CacheableReference2_0 parentEntity = (CacheableReference2_0)this.getParentEntity();
        return parentEntity == null ? null : parentEntity.getCacheable();
    }

    protected class DiscriminatorFormulaOwner
    implements JavaDiscriminatorFormula.Owner {
        protected DiscriminatorFormulaOwner() {
        }

        @Override
        public TypeMapping getTypeMapping() {
            return HibernateJavaEntityImpl.this;
        }

        @Override
        public String getDefaultTableName() {
            return HibernateJavaEntityImpl.this.getPrimaryTableName();
        }

        @Override
        public org.eclipse.jpt.jpa.db.Table resolveDbTable(String tableName) {
            return HibernateJavaEntityImpl.this.resolveDbTable(tableName);
        }
    }

    class HibernatePrimaryKeyJoinColumnOwner
    extends AbstractJavaEntity.PrimaryKeyJoinColumnParentAdapter {
        HibernatePrimaryKeyJoinColumnOwner() {
            super((AbstractJavaEntity)HibernateJavaEntityImpl.this);
        }

        public TextRange getValidationTextRange() {
            return HibernateJavaEntityImpl.this.getValidationTextRange();
        }

        public String getDefaultTableName() {
            return HibernateJavaEntityImpl.this.getPrimaryTableName();
        }

        public org.eclipse.jpt.jpa.db.Table getDbTable(String tableName) {
            return HibernateJavaEntityImpl.this.resolveDbTable(tableName);
        }

        public org.eclipse.jpt.jpa.db.Table getReferencedColumnDbTable() {
            Entity parentEntity = HibernateJavaEntityImpl.this.getParentEntity();
            return parentEntity == null ? null : parentEntity.getPrimaryDbTable();
        }

        public int getJoinColumnsSize() {
            return HibernateJavaEntityImpl.this.getPrimaryKeyJoinColumnsSize();
        }

        public boolean isVirtual(BaseJoinColumn joinColumn) {
            return HibernateJavaEntityImpl.this.defaultPrimaryKeyJoinColumn == joinColumn;
        }

        public String getDefaultColumnName(NamedColumn column) {
            if (this.getJoinColumnsSize() != 1) {
                return null;
            }
            Entity parentEntity = HibernateJavaEntityImpl.this.getParentEntity();
            if (parentEntity != null) {
                HibernateJpaProject hibernateJpaProject = HibernateJavaEntityImpl.this.getJpaProject();
                INamingStrategy ns = hibernateJpaProject.getNamingStrategy();
                if (hibernateJpaProject.isNamingStrategyEnabled() && ns != null) {
                    try {
                        String name = ns.joinKeyColumnName(parentEntity.getPrimaryKeyColumnName(), parentEntity.getPrimaryTableName());
                        if (parentEntity.getPrimaryDbTable() != null) {
                            return parentEntity.getPrimaryDbTable().getDatabase().convertNameToIdentifier(name);
                        }
                        return name;
                    }
                    catch (Exception e) {
                        IMessage m = HibernateJpaValidationMessage.buildMessage(1, "NAMING_STRATEGY_EXCEPTION", (JpaModel)column);
                        HibernateJptPlugin.logException(m.getText(), e);
                    }
                }
                return parentEntity.getPrimaryKeyColumnName();
            }
            return HibernateJavaEntityImpl.this.getPrimaryKeyColumnName();
        }
    }
}

