/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.jpt.core.internal.context.java;

import java.util.List;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.jpa.core.context.java.JavaConverter;
import org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedPersistentAttribute;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaBasicMapping;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.jboss.tools.hibernate.jpt.core.internal.HibernateAbstractJpaFactory;
import org.jboss.tools.hibernate.jpt.core.internal.context.GenerationTime;
import org.jboss.tools.hibernate.jpt.core.internal.context.java.HibernateJavaBasicMapping;
import org.jboss.tools.hibernate.jpt.core.internal.context.java.JavaIndex;
import org.jboss.tools.hibernate.jpt.core.internal.context.java.JavaType;
import org.jboss.tools.hibernate.jpt.core.internal.resource.java.GeneratedAnnotation;
import org.jboss.tools.hibernate.jpt.core.internal.resource.java.IndexAnnotation;
import org.jboss.tools.hibernate.jpt.core.internal.resource.java.TypeAnnotation;

public class HibernateJavaBasicMappingImpl
extends AbstractJavaBasicMapping
implements HibernateJavaBasicMapping {
    protected static final Iterable<JavaConverter.Adapter> HIBERNATE_CONVERTER_ADAPTERS = IterableTools.iterable((Object[])CONVERTER_ADAPTER_ARRAY);
    protected GenerationTime specifiedGenerationTime;
    protected JavaIndex index = this.buildIndex();
    protected JavaType type = this.buildType();

    public HibernateJavaBasicMappingImpl(JavaSpecifiedPersistentAttribute parent) {
        super(parent);
    }

    protected HibernateAbstractJpaFactory getJpaFactory() {
        return (HibernateAbstractJpaFactory)super.getJpaFactory();
    }

    protected Iterable<JavaConverter.Adapter> getConverterAdapters() {
        return HIBERNATE_CONVERTER_ADAPTERS;
    }

    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.specifiedGenerationTime = this.getResourceGenerationTime();
        this.syncIndex();
        this.syncType();
    }

    public void update() {
        super.update();
        this.setGenerationTime_(this.getResourceGenerationTime());
        if (this.index != null) {
            this.index.update();
        }
        if (this.type != null) {
            this.type.update();
        }
    }

    public GeneratedAnnotation getGeneratedAnnotation() {
        return (GeneratedAnnotation)this.getResourceAttribute().getAnnotation("org.hibernate.annotations.Generated");
    }

    public GeneratedAnnotation buildGeneratedAnnotation() {
        return (GeneratedAnnotation)this.getResourceAttribute().addAnnotation("org.hibernate.annotations.Generated");
    }

    public void removeGeneratedAnnotation() {
        this.getResourceAttribute().removeAnnotation("org.hibernate.annotations.Generated");
    }

    protected GenerationTime getResourceGenerationTime() {
        GeneratedAnnotation geneatedAnnotation = this.getGeneratedAnnotation();
        return geneatedAnnotation == null ? null : geneatedAnnotation.getValue();
    }

    @Override
    public GenerationTime getGenerationTime() {
        return this.specifiedGenerationTime;
    }

    @Override
    public void setGenerationTime(GenerationTime newValue) {
        GenerationTime oldValue = this.specifiedGenerationTime;
        this.specifiedGenerationTime = newValue;
        if (newValue != null) {
            GeneratedAnnotation annotation = this.getGeneratedAnnotation() != null ? this.getGeneratedAnnotation() : this.buildGeneratedAnnotation();
            annotation.setValue(newValue);
        } else {
            this.removeGeneratedAnnotation();
        }
        this.firePropertyChanged("value", (Object)oldValue, (Object)newValue);
    }

    public void setGenerationTime_(GenerationTime newGenerationTime) {
        GenerationTime oldValue = this.specifiedGenerationTime;
        this.specifiedGenerationTime = newGenerationTime;
        this.firePropertyChanged("value", (Object)oldValue, (Object)newGenerationTime);
    }

    @Override
    public JavaIndex getIndex() {
        return this.index;
    }

    @Override
    public JavaIndex addIndex() {
        if (this.getIndex() != null) {
            throw new IllegalStateException("index already exists");
        }
        IndexAnnotation annotation = this.buildIndexAnnotation();
        JavaIndex index = this.buildIndex(annotation);
        this.setIndex(index);
        return index;
    }

    protected IndexAnnotation buildIndexAnnotation() {
        return (IndexAnnotation)this.getResourceAttribute().addAnnotation("org.hibernate.annotations.Index");
    }

    @Override
    public void removeIndex() {
        if (this.getIndex() == null) {
            throw new IllegalStateException("index does not exist, cannot be removed");
        }
        this.getResourceAttribute().removeAnnotation("org.hibernate.annotations.Index");
        this.setIndex(null);
    }

    protected JavaIndex buildIndex() {
        IndexAnnotation annotation = this.getIndexAnnotation();
        return annotation == null ? null : this.buildIndex(annotation);
    }

    protected IndexAnnotation getIndexAnnotation() {
        return (IndexAnnotation)this.getResourceAttribute().getAnnotation("org.hibernate.annotations.Index");
    }

    protected JavaIndex buildIndex(IndexAnnotation annotation) {
        return this.getJpaFactory().buildIndex(this, annotation);
    }

    protected void syncIndex() {
        IndexAnnotation annotation = this.getIndexAnnotation();
        if (annotation == null) {
            if (this.getIndex() != null) {
                this.setIndex(null);
            }
        } else if (this.getIndex() != null && this.getIndex().getIndexAnnotation() == annotation) {
            this.index.synchronizeWithResourceModel();
        } else {
            this.setIndex(this.buildIndex(annotation));
        }
    }

    protected void setIndex(JavaIndex newIndex) {
        JavaIndex oldIndex = this.index;
        this.index = newIndex;
        this.firePropertyChanged("index", oldIndex, newIndex);
    }

    @Override
    public JavaType getType() {
        return this.type;
    }

    @Override
    public JavaType addType() {
        if (this.type != null) {
            throw new IllegalStateException("type already exists: " + this.type);
        }
        TypeAnnotation annotation = this.buildTypeAnnotation();
        JavaType value = this.buildType(annotation);
        this.setType(value);
        return value;
    }

    protected TypeAnnotation buildTypeAnnotation() {
        return (TypeAnnotation)this.getResourceAttribute().addAnnotation("org.hibernate.annotations.Type");
    }

    @Override
    public void removeType() {
        if (this.type == null) {
            throw new IllegalStateException("generated value does not exist");
        }
        this.getResourceAttribute().removeAnnotation("org.hibernate.annotations.Type");
        this.setType(null);
    }

    protected JavaType buildType() {
        TypeAnnotation annotation = this.getTypeAnnotation();
        return annotation == null ? null : this.buildType(annotation);
    }

    protected TypeAnnotation getTypeAnnotation() {
        return (TypeAnnotation)this.getResourceAttribute().getAnnotation("org.hibernate.annotations.Type");
    }

    protected JavaType buildType(TypeAnnotation generatedValueAnnotation) {
        return this.getJpaFactory().buildType(this, generatedValueAnnotation);
    }

    protected void syncType() {
        TypeAnnotation annotation = this.getTypeAnnotation();
        if (annotation == null) {
            if (this.type != null) {
                this.setType(null);
            }
        } else if (this.type != null && this.type.getTypeAnnotation() == annotation) {
            this.type.synchronizeWithResourceModel();
        } else {
            this.setType(this.buildType(annotation));
        }
    }

    protected void setType(JavaType value) {
        JavaType old = this.type;
        this.type = value;
        this.firePropertyChanged("type", old, value);
    }

    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        if (this.index != null) {
            this.index.validate(messages, reporter);
        }
        if (this.type != null) {
            this.type.validate(messages, reporter);
        }
    }
}

